/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.entity;

import com.socialize.entity.Entity;
import com.socialize.entity.EntityFactory;
import com.socialize.entity.SocializeObjectFactory;
import com.socialize.entity.Subscription;
import com.socialize.entity.User;
import com.socialize.entity.UserFactory;
import com.socialize.log.SocializeLogger;
import com.socialize.notifications.NotificationType;
import com.socialize.util.StringUtils;
import java.text.ParseException;
import org.json.JSONException;
import org.json.JSONObject;

public class SubscriptionFactory
extends SocializeObjectFactory<Subscription> {
    private UserFactory userFactory;
    private EntityFactory entityFactory;
    private SocializeLogger logger;

    @Override
    protected void postFromJSON(JSONObject from, Subscription to) throws JSONException {
        try {
            block12: {
                JSONObject entity;
                JSONObject user;
                if (from.has("user") && !from.isNull("user") && (user = from.getJSONObject("user")) != null) {
                    to.setUser((User)this.userFactory.fromJSON(user));
                }
                if (from.has("entity") && !from.isNull("entity") && (entity = from.getJSONObject("entity")) != null) {
                    to.setEntity((Entity)this.entityFactory.fromJSON(entity));
                }
                if (from.has("subscribed") && !from.isNull("subscribed")) {
                    to.setSubscribed(from.getBoolean("subscribed"));
                }
                if (from.has("date") && !from.isNull("date")) {
                    try {
                        to.setDate(this.DATE_FORMAT.parse(from.getString("date")).getTime());
                    }
                    catch (ParseException e) {
                        if (this.logger == null || !this.logger.isWarnEnabled()) break block12;
                        this.logger.warn("Could not parse date [" + from.getString("date") + "] using format [" + "yyyy-MM-dd HH:mm:ssZZ" + "]");
                    }
                }
            }
            if (from.has("type") && !from.isNull("type")) {
                try {
                    to.setNotificationType(NotificationType.valueOf(from.getString("type").toUpperCase()));
                }
                catch (Exception e) {
                    if (this.logger != null && this.logger.isWarnEnabled()) {
                        this.logger.warn("Could not parse type [" + from.getString("type") + "] into " + NotificationType.class.getName());
                    }
                }
            }
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage());
        }
    }

    @Override
    protected void postToJSON(Subscription from, JSONObject to) throws JSONException {
        try {
            Entity entityObject = from.getEntity();
            User userObject = from.getUser();
            Long date = from.getDate();
            if (entityObject != null) {
                if (!StringUtils.isEmpty(entityObject.getName()) && !StringUtils.isEmpty(entityObject.getKey())) {
                    JSONObject entity = this.entityFactory.toJSON(entityObject);
                    to.put("entity", (Object)entity);
                } else if (!StringUtils.isEmpty(entityObject.getKey())) {
                    to.put("entity_key", (Object)entityObject.getKey());
                }
            }
            if (userObject != null) {
                JSONObject user = this.userFactory.toJSON(userObject);
                to.put("user", (Object)user);
            }
            if (date != null) {
                to.put("date", (Object)this.DATE_FORMAT.format(date));
            }
            to.put("subscribed", from.isSubscribed());
            to.put("type", (Object)from.getNotificationType().name().toLowerCase());
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage());
        }
    }

    @Override
    public Object instantiateObject(JSONObject object) {
        return new Subscription();
    }

    public void setUserFactory(UserFactory userFactory) {
        this.userFactory = userFactory;
    }

    public void setEntityFactory(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }
}

