/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.entity;

import com.socialize.api.action.ActionType;
import com.socialize.entity.Comment;
import com.socialize.entity.CommentFactory;
import com.socialize.entity.Like;
import com.socialize.entity.LikeFactory;
import com.socialize.entity.Share;
import com.socialize.entity.ShareFactory;
import com.socialize.entity.SocializeAction;
import com.socialize.entity.SocializeActionFactory;
import com.socialize.entity.View;
import com.socialize.entity.ViewFactory;
import com.socialize.log.SocializeLogger;
import org.json.JSONException;
import org.json.JSONObject;

public class GenericActionFactory
extends SocializeActionFactory<SocializeAction> {
    private SocializeLogger logger;
    private CommentFactory commentFactory;
    private LikeFactory likeFactory;
    private ViewFactory viewFactory;
    private ShareFactory shareFactory;

    @Override
    protected void postFromJSON(JSONObject from, SocializeAction to) throws JSONException {
        switch (to.getActionType()) {
            case COMMENT: {
                this.commentFactory.postFromJSON(from, (Comment)to);
                break;
            }
            case SHARE: {
                this.shareFactory.postFromJSON(from, (Share)to);
                break;
            }
            case VIEW: {
                this.viewFactory.postFromJSON(from, (View)to);
                break;
            }
            case LIKE: {
                this.likeFactory.postFromJSON(from, (Like)to);
            }
        }
    }

    @Override
    protected void postToJSON(SocializeAction from, JSONObject to) throws JSONException {
        switch (from.getActionType()) {
            case COMMENT: {
                this.commentFactory.postToJSON((Comment)from, to);
                break;
            }
            case SHARE: {
                this.shareFactory.postToJSON((Share)from, to);
                break;
            }
            case VIEW: {
                this.viewFactory.postToJSON((View)from, to);
                break;
            }
            case LIKE: {
                this.likeFactory.postToJSON((Like)from, to);
            }
        }
    }

    @Override
    public Object instantiateObject(JSONObject from) {
        block12: {
            if (from.has("activity_type") && !from.isNull("activity_type")) {
                try {
                    String type = from.getString("activity_type").toUpperCase();
                    ActionType actionType = ActionType.valueOf(type);
                    switch (actionType) {
                        case COMMENT: {
                            return this.commentFactory.instantiateObject(from);
                        }
                        case SHARE: {
                            return this.shareFactory.instantiateObject(from);
                        }
                        case VIEW: {
                            return this.viewFactory.instantiateObject(from);
                        }
                        case LIKE: {
                            return this.likeFactory.instantiateObject(from);
                        }
                    }
                }
                catch (JSONException e) {
                    if (this.logger != null) {
                        this.logger.error("Error getting activity type", (Throwable)e);
                        break block12;
                    }
                    SocializeLogger.e(e.getMessage(), e);
                }
            } else if (this.logger != null) {
                this.logger.warn("No attribute [activity_type] found in object [" + from.toString() + "]");
            }
        }
        return null;
    }

    @Override
    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setCommentFactory(CommentFactory commentFactory) {
        this.commentFactory = commentFactory;
    }

    public void setLikeFactory(LikeFactory likeFactory) {
        this.likeFactory = likeFactory;
    }

    public void setViewFactory(ViewFactory viewFactory) {
        this.viewFactory = viewFactory;
    }

    public void setShareFactory(ShareFactory shareFactory) {
        this.shareFactory = shareFactory;
    }
}

