/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.config;

import android.content.Context;
import com.socialize.log.ExternalLogger;
import com.socialize.log.SocializeLogger;
import com.socialize.util.ResourceLocator;
import com.socialize.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SocializeConfig {
    public static final String SOCIALIZE_PROPERTIES_PATH = "socialize.properties";
    public static final String DEFAULT_PROPERTIES_PATH = "default.socialize.properties";
    public static final String SOCIALIZE_CORE_BEANS_PATH = "socialize_core_beans.xml";
    public static final String SOCIALIZE_UI_BEANS_PATH = "socialize_ui_beans.xml";
    public static final String SOCIALIZE_NOTIFICATION_BEANS_PATH = "socialize_notification_beans.xml";
    public static final String SOCIALIZE_ERRORS_PATH = "socialize.errors.properties";
    public static final String SOCIALIZE_CONSUMER_KEY = "socialize.consumer.key";
    public static final String SOCIALIZE_CONSUMER_SECRET = "socialize.consumer.secret";
    public static final String SOCIALIZE_CHECK_NOTIFICATIONS = "socialize.check.notifications";
    public static final String SOCIALIZE_NOTIFICATION_APP_ICON = "socialize.notification.app.icon";
    public static final String GCM_REGISTRATION_INTERVAL = "gcm.registration.interval";
    public static final String GCM_REGISTRATION_ENABLED = "gcm.registration.enabled";
    public static final String SOCIALIZE_NOTIFICATIONS_INTERVAL = "socialize.notification.request.interval";
    public static final String SOCIALIZE_NOTIFICATIONS_ENABLED = "socialize.notification.enabled";
    @Deprecated
    public static final String SOCIALIZE_C2DM_SENDER_ID = "socialize.c2dm.sender.id";
    public static final String SOCIALIZE_GCM_SENDER_ID = "socialize.gcm.sender.id";
    public static final String SOCIALIZE_CUSTOM_GCM_SENDER_ID = "socialize.custom.gcm.sender.id";
    public static final String SOCIALIZE_ENTITY_LOADER = "socialize.entity.loader";
    public static final String SOCIALIZE_LOCATION_ENABLED = "socialize.location.enabled";
    public static final String SOCIALIZE_REQUIRE_AUTH = "socialize.require.auth";
    public static final String SOCIALIZE_EXTERNAL_LOGS_ENABLED = "socialize.external.logs.enabled";
    @Deprecated
    public static final String SOCIALIZE_REQUIRE_SHARE = "socialize.require.share";
    public static final String SOCIALIZE_ALLOW_ANON = "socialize.allow.anon";
    public static final String SOCIALIZE_ALLOW_ANON_COMMENT = "socialize.allow.anon.comments";
    public static final String SOCIALIZE_ALLOW_NEVER_AUTH = "socialize.allow.never.auth";
    public static final String SOCIALIZE_EVENTS_AUTH_ENABLED = "socialize.events.auth.enabled";
    public static final String SOCIALIZE_EVENTS_SHARE_ENABLED = "socialize.events.share.enabled";
    public static final String SOCIALIZE_SHOW_COMMENT_LIST_ON_NOTIFY = "socialize.comments.on.notify";
    public static final String SOCIALIZE_SHOW_COMMENT_HEADER = "socialize.show.comment.header";
    public static final String SOCIALIZE_PROMPT_SHARE = "socialize.prompt.share";
    public static final String SOCIALIZE_ALLOW_DELETE_COMMENT = "socialize.allow.delete.comment";
    public static final String GOOGLE_PLUS_ENABLED = "googleplus.enabled";
    public static final String LOOPY_ENABLED = "loopy.enabled";
    public static final String FACEBOOK_SSO_ENABLED = "facebook.sso.enabled";
    public static final String FACEBOOK_OG_USE_INBUILT_LIKE = "facebook.og.like.enabled";
    @Deprecated
    public static final String FACEBOOK_PHOTOS_ENABLED = "facebook.photos.enabled";
    public static final String FACEBOOK_APP_ID = "facebook.app.id";
    @Deprecated
    public static final String FACEBOOK_USER_ID = "facebook.user.id";
    @Deprecated
    public static final String FACEBOOK_USER_TOKEN = "facebook.user.token";
    public static final String TWITTER_CONSUMER_KEY = "twitter.consumer.key";
    public static final String TWITTER_CONSUMER_SECRET = "twitter.consumer.secret";
    private Properties properties;
    private SocializeLogger logger;
    private ResourceLocator resourceLocator;
    private String propertiesFileName = "socialize.properties";
    public static final String LOG_LEVEL = "log.level";
    public static final String LOG_TAG = "log.tag";
    public static final String LOG_THREAD = "log.thread";
    public static final String LOG_MSG = "log.msg.";
    public static final String API_HOST = "api.host";
    public static final String REDIRECT_APP_STORE = "redirect.app.store";
    public static final String HTTP_CONNECTION_TIMEOUT = "http.connection.timeout";
    public static final String HTTP_SOCKET_TIMEOUT = "http.socket.timeout";
    public static final int MAX_LIST_RESULTS = 100;
    public static final String SOCIALIZE_SHARE_COMMENT = "socialize.share.comment";
    public static final String SOCIALIZE_SHARE_IS_HTML = "socialize.share.html";
    public static final String SOCIALIZE_SHARE_MIME_TYPE = "socialize.share.mime";
    public static final String SOCIALIZE_SHARE_LISTENER_KEY = "socialize.share.listener.key";
    private static boolean ENTITY_LOADER_CHECK_ENABLED = true;

    public SocializeConfig() {
    }

    public SocializeConfig(String propertiesFileName) {
        this.propertiesFileName = propertiesFileName;
    }

    public void init(Context context) {
        this.init(context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Context context, boolean override) {
        InputStream in = null;
        try {
            if (this.resourceLocator != null) {
                try {
                    in = this.resourceLocator.locateInClassPath(context, DEFAULT_PROPERTIES_PATH);
                    if (in != null) {
                        Properties old = null;
                        if (this.properties != null) {
                            old = this.properties;
                        }
                        this.properties = this.createProperties();
                        this.properties.load(in);
                        this.trimValues(this.properties);
                        if (old != null) {
                            this.merge(old, null);
                        }
                    } else if (this.logger != null) {
                        this.logger.error("Could not locate config [default.socialize.properties] in classpath");
                    }
                }
                catch (IOException ignore) {
                    ignore.printStackTrace();
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                if (override) {
                    try {
                        in = this.resourceLocator.locate(context, this.propertiesFileName);
                        if (in != null) {
                            Properties overrideProps = this.createProperties();
                            overrideProps.load(in);
                            this.trimValues(overrideProps);
                            this.merge(overrideProps, null);
                        }
                    }
                    catch (IOException ignore) {
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
            }
            if (this.properties == null) {
                if (this.logger != null) {
                    this.logger.error(3);
                }
                this.properties = this.createProperties();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void trimValues(Properties properties) {
        Set<Object> keys;
        if (properties != null && (keys = properties.keySet()) != null) {
            String value = null;
            for (Object key : keys) {
                value = properties.getProperty(key.toString());
                if (value == null) continue;
                value = value.trim();
                properties.put(key, value);
            }
        }
    }

    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = this.createProperties();
        }
        if (value != null) {
            value = value.trim();
            this.properties.put(key, value);
        } else {
            this.properties.remove(key);
        }
    }

    public String getProperty(String key) {
        return this.properties == null ? null : this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.properties == null) {
            return defaultValue;
        }
        String value = this.properties.getProperty(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    public void destroy() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    public int getIntProperty(String key, int defaultValue) {
        String val = this.getProperty(key);
        if (!StringUtils.isEmpty(val)) {
            return Integer.parseInt(val);
        }
        return defaultValue;
    }

    public long getLongProperty(String key, long defaultValue) {
        String val = this.getProperty(key);
        if (!StringUtils.isEmpty(val)) {
            return Long.parseLong(val);
        }
        return defaultValue;
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String val = this.getProperty(key);
        if (!StringUtils.isEmpty(val)) {
            return Boolean.parseBoolean(val);
        }
        return defaultValue;
    }

    public void setFacebookAppId(String appId) {
        this.setProperty(FACEBOOK_APP_ID, appId);
    }

    public void setTwitterKeySecret(String consumerKey, String consumerSecret) {
        this.setProperty(TWITTER_CONSUMER_KEY, consumerKey);
        this.setProperty(TWITTER_CONSUMER_SECRET, consumerSecret);
    }

    public void setFacebookSingleSignOnEnabled(boolean enabled) {
        this.setProperty(FACEBOOK_SSO_ENABLED, String.valueOf(enabled));
    }

    @Deprecated
    public void setFacebookUserCredentials(String userId, String token) {
        this.setProperty(FACEBOOK_USER_ID, userId);
        this.setProperty(FACEBOOK_USER_TOKEN, token);
    }

    @Deprecated
    public boolean isShareRequired() {
        return this.getBooleanProperty(SOCIALIZE_REQUIRE_SHARE, this.getBooleanProperty(SOCIALIZE_ALLOW_ANON, false));
    }

    public boolean isAllowSkipAuthOnComments() {
        return this.getBooleanProperty(SOCIALIZE_ALLOW_ANON_COMMENT, false);
    }

    public boolean isLoopyEnabled() {
        return this.getBooleanProperty(LOOPY_ENABLED, true);
    }

    public boolean isDiagnosticLoggingEnabled() {
        return this.getBooleanProperty(SOCIALIZE_EXTERNAL_LOGS_ENABLED, false);
    }

    public void setDiagnosticLoggingEnabled(Context context, boolean enabled) {
        this.setProperty(SOCIALIZE_EXTERNAL_LOGS_ENABLED, String.valueOf(enabled));
        if (this.logger != null) {
            if (enabled) {
                this.logger.destroy();
                this.logger.init(context, this);
            } else {
                ExternalLogger externalLogger = this.logger.getExternalLogger();
                if (externalLogger != null) {
                    externalLogger.destroy();
                }
                this.logger.setExternalLogger(null);
            }
        }
    }

    public boolean isAllowSkipAuthOnAllActions() {
        return this.getBooleanProperty(SOCIALIZE_ALLOW_ANON, false);
    }

    public boolean isAllowNeverAuth() {
        return this.getBooleanProperty(SOCIALIZE_ALLOW_NEVER_AUTH, false);
    }

    public boolean isAllowDeleteComment() {
        return this.getBooleanProperty(SOCIALIZE_ALLOW_DELETE_COMMENT, false);
    }

    public boolean isShowCommentHeader() {
        return this.getBooleanProperty(SOCIALIZE_SHOW_COMMENT_HEADER, true);
    }

    public boolean isOGLike() {
        return this.getBooleanProperty(FACEBOOK_OG_USE_INBUILT_LIKE, false);
    }

    public boolean isGooglePlusEnabled() {
        return this.getBooleanProperty(GOOGLE_PLUS_ENABLED, true);
    }

    public boolean isNotificationsEnabled() {
        return this.getBooleanProperty(SOCIALIZE_NOTIFICATIONS_ENABLED, true);
    }

    public boolean isPromptForAuth() {
        return this.getBooleanProperty(SOCIALIZE_REQUIRE_AUTH, true);
    }

    public boolean isPromptForShare() {
        return this.getBooleanProperty(SOCIALIZE_PROMPT_SHARE, true);
    }

    public void setSocializeCredentials(String consumerKey, String consumerSecret) {
        this.setProperty(SOCIALIZE_CONSUMER_KEY, consumerKey);
        this.setProperty(SOCIALIZE_CONSUMER_SECRET, consumerSecret);
    }

    protected String getLocalProperty(String key) {
        return this.getLocalProperty(key, null);
    }

    protected String getLocalProperty(String key, String defaultValue) {
        String val = this.properties.getProperty(key);
        if (!StringUtils.isEmpty(val)) {
            return val;
        }
        return defaultValue;
    }

    public void merge(SocializeConfig config) {
        this.merge(config.getProperties(), null);
    }

    public void merge(Properties other, Set<String> toBeRemoved) {
        if (this.properties == null) {
            this.properties = this.createProperties();
        }
        if (other != null && other.size() > 0) {
            Set<Map.Entry<Object, Object>> entrySet = other.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                this.properties.put(entry.getKey(), entry.getValue());
            }
        }
        if (toBeRemoved != null && toBeRemoved.size() > 0) {
            for (String key : toBeRemoved) {
                this.properties.remove(key);
            }
            toBeRemoved.clear();
        }
    }

    public String getDefaultPropertiesFileName() {
        return SOCIALIZE_PROPERTIES_PATH;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setResourceLocator(ResourceLocator resourceLocator) {
        this.resourceLocator = resourceLocator;
    }

    protected Properties createProperties() {
        return new Properties();
    }

    public boolean isEntityLoaderCheckEnabled() {
        return ENTITY_LOADER_CHECK_ENABLED;
    }

    protected void setEntityLoaderCheckEnabled(boolean entityLoaderCheckEnabled) {
        ENTITY_LOADER_CHECK_ENABLED = entityLoaderCheckEnabled;
    }
}

