/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.concurrent;

import android.os.AsyncTask;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncTaskManager {
    private static boolean managed = false;
    private static AtomicInteger ids = new AtomicInteger(0);
    private static Map<Integer, AsyncTask<?, ?, ?>> tasks = new ConcurrentHashMap();

    public static int register(AsyncTask<?, ?, ?> task) {
        int id = ids.getAndIncrement();
        tasks.put(id, task);
        return id;
    }

    public static boolean isManaged() {
        return managed;
    }

    public static void setManaged(boolean managed) {
        AsyncTaskManager.managed = managed;
    }

    public static void unregister(int id) {
        tasks.remove(id);
    }

    public static synchronized boolean terminateAll(long timeout, TimeUnit unit) {
        Set<Map.Entry<Integer, AsyncTask<?, ?, ?>>> entrySet = tasks.entrySet();
        if (!entrySet.isEmpty()) {
            int count = entrySet.size();
            int cancelled = 0;
            if (count > 0) {
                long incrementalTime = timeout / (long)count;
                for (Map.Entry<Integer, AsyncTask<?, ?, ?>> entry : entrySet) {
                    AsyncTask<?, ?, ?> task = entry.getValue();
                    try {
                        task.get(incrementalTime, unit);
                        ++cancelled;
                    }
                    catch (Exception e) {
                        if (!task.cancel(true)) continue;
                        ++cancelled;
                    }
                }
                tasks.clear();
            }
            return cancelled == count;
        }
        return true;
    }
}

