/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.cache;

import com.socialize.cache.ICacheable;

public class TTLObject<K extends Comparable<K>, E extends ICacheable<K>> {
    private E object;
    private K key;
    private boolean eternal = false;
    private long lifeExpectancy;
    private long ttl;

    public TTLObject() {
    }

    public TTLObject(E obj, K key, long ttl) {
        this.object = obj;
        this.key = key;
        this.ttl = ttl;
        this.extendLife(ttl);
    }

    public void extendLife(long ttl) {
        if (ttl > 0L) {
            long time = System.currentTimeMillis();
            this.lifeExpectancy = ttl < Long.MAX_VALUE - time ? time + ttl : ttl;
        } else {
            this.eternal = true;
        }
    }

    public long getLifeExpectancy() {
        return this.lifeExpectancy;
    }

    public long getTtl() {
        return this.ttl;
    }

    public E getObject() {
        return this.object;
    }

    public K getKey() {
        return this.key;
    }

    public boolean equals(Object obj) {
        return this.object.equals(obj);
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public String toString() {
        return this.object.toString();
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public void setEternal(boolean eternal) {
        this.eternal = eternal;
    }

    public void setLifeExpectancy(long lifeExpectancy) {
        this.lifeExpectancy = lifeExpectancy;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public void setObject(E object) {
        this.object = object;
    }

    public void setKey(K key) {
        this.key = key;
    }
}

