/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.auth.twitter;

import android.app.Dialog;
import android.graphics.Bitmap;
import android.net.Uri;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.socialize.auth.twitter.OAuthRequestListener;
import com.socialize.ui.dialog.SafeProgressDialog;
import com.socialize.util.StringUtils;

public class TwitterWebViewClient
extends WebViewClient {
    private OAuthRequestListener oAuthRequestListener;
    private boolean called = false;
    private boolean close = false;
    private Dialog progress;

    public void setOauthRequestListener(OAuthRequestListener oAuthRequestListener) {
        this.oAuthRequestListener = oAuthRequestListener;
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (this.progress != null) {
            this.progress.dismiss();
        }
        if (this.close) {
            view.setVisibility(8);
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        if (url.trim().toLowerCase().startsWith("socializeoauth://sign-in-with-twitter".toLowerCase())) {
            this.progress = SafeProgressDialog.show(view.getContext());
            if (!this.called) {
                this.called = true;
                Uri uri = Uri.parse((String)url);
                String cancelToken = uri.getQueryParameter("denied");
                if (!StringUtils.isEmpty(cancelToken)) {
                    if (this.oAuthRequestListener != null) {
                        this.oAuthRequestListener.onCancel(cancelToken);
                    }
                } else {
                    String token = uri.getQueryParameter("oauth_token");
                    String verifier = uri.getQueryParameter("oauth_verifier");
                    if (this.oAuthRequestListener != null) {
                        this.oAuthRequestListener.onRequestToken(token, verifier);
                    }
                }
                this.close = true;
            }
            this.progress.dismiss();
        } else {
            super.onPageStarted(view, url, favicon);
        }
    }
}

