/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api.action.user;

import android.content.Context;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.api.SessionLock;
import com.socialize.api.SocializeApi;
import com.socialize.api.SocializeSession;
import com.socialize.api.SocializeSessionConsumer;
import com.socialize.api.SocializeSessionPersister;
import com.socialize.api.action.user.UserSystem;
import com.socialize.auth.AuthProviderData;
import com.socialize.auth.AuthProviderInfo;
import com.socialize.auth.AuthProviderInfoBuilder;
import com.socialize.auth.AuthProviderType;
import com.socialize.auth.SocializeAuthProviderInfo;
import com.socialize.auth.SocializeAuthProviderInfoFactory;
import com.socialize.auth.UserProviderCredentials;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.User;
import com.socialize.error.SocializeException;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.listener.user.UserListener;
import com.socialize.listener.user.UserSaveListener;
import com.socialize.log.SocializeLogger;
import com.socialize.notifications.NotificationRegistrationSystem;
import com.socialize.provider.SocializeProvider;
import com.socialize.ui.profile.UserSettings;
import com.socialize.util.BitmapUtils;
import com.socialize.util.DeviceUtils;
import com.socialize.util.StringUtils;

public class SocializeUserSystem
extends SocializeApi<User, SocializeProvider<User>>
implements UserSystem {
    private IBeanFactory<AuthProviderData> authProviderDataFactory;
    private SocializeSessionPersister sessionPersister;
    private DeviceUtils deviceUtils;
    private SocializeLogger logger;
    private AuthProviderInfoBuilder authProviderInfoBuilder;
    private SocializeAuthProviderInfoFactory socializeAuthProviderInfoFactory;
    private NotificationRegistrationSystem notificationRegistrationSystem;
    private BitmapUtils bitmapUtils;

    public SocializeUserSystem(SocializeProvider<User> provider) {
        super(provider);
    }

    @Override
    public void authenticate(Context context, SocializeAuthListener listener, SocializeSessionConsumer sessionConsumer) {
        String consumerKey = this.config.getProperty("socialize.consumer.key");
        String consumerSecret = this.config.getProperty("socialize.consumer.secret");
        this.authenticate(context, consumerKey, consumerSecret, listener, sessionConsumer);
    }

    @Override
    public void authenticate(Context context, String consumerKey, String consumerSecret, AuthProviderInfo authProviderInfo, SocializeAuthListener listener, SocializeSessionConsumer sessionConsumer) {
        AuthProviderData data = (AuthProviderData)this.authProviderDataFactory.getBean();
        data.setAuthProviderInfo(authProviderInfo);
        this.authenticate(context, consumerKey, consumerSecret, data, listener, sessionConsumer, true);
    }

    @Override
    public void authenticateKnownUser(Context context, UserProviderCredentials userProviderCredentials, SocializeAuthListener listener, SocializeSessionConsumer sessionConsumer) {
        String consumerKey = this.config.getProperty("socialize.consumer.key");
        String consumerSecret = this.config.getProperty("socialize.consumer.secret");
        AuthProviderData authProviderData = (AuthProviderData)this.authProviderDataFactory.getBean();
        authProviderData.setAuthProviderInfo(userProviderCredentials.getAuthProviderInfo());
        authProviderData.setToken3rdParty(userProviderCredentials.getAccessToken());
        authProviderData.setSecret3rdParty(userProviderCredentials.getTokenSecret());
        authProviderData.setUserId3rdParty(userProviderCredentials.getUserId());
        this.authenticate(context, consumerKey, consumerSecret, authProviderData, listener, sessionConsumer, false);
    }

    @Override
    public void authenticate(Context context, String consumerKey, String consumerSecret, SocializeAuthListener listener, SocializeSessionConsumer sessionConsumer) {
        AuthProviderData authProviderData = (AuthProviderData)this.authProviderDataFactory.getBean();
        authProviderData.setAuthProviderInfo((AuthProviderInfo)this.socializeAuthProviderInfoFactory.getInstanceForRead(new String[0]));
        this.authenticate(context, consumerKey, consumerSecret, authProviderData, listener, sessionConsumer, false);
    }

    @Override
    public void authenticate(Context context, AuthProviderType authProviderType, SocializeAuthListener listener, SocializeSessionConsumer sessionConsumer) {
        String consumerKey = this.config.getProperty("socialize.consumer.key");
        String consumerSecret = this.config.getProperty("socialize.consumer.secret");
        Object authProviderInfo = this.authProviderInfoBuilder.getFactory(authProviderType).getInstanceForRead(new String[0]);
        this.authenticate(context, consumerKey, consumerSecret, (AuthProviderInfo)authProviderInfo, listener, sessionConsumer);
    }

    @Override
    public void authenticate(Context ctx, String consumerKey, String consumerSecret, AuthProviderData authProviderData, SocializeAuthListener listener, SocializeSessionConsumer sessionConsumer, boolean do3rdPartyAuth) {
        if (this.checkKeys(consumerKey, consumerSecret, listener)) {
            String udid = this.deviceUtils.getUDID(ctx);
            String advertiserId = this.deviceUtils.getAndroidID(ctx);
            if (StringUtils.isEmpty(udid)) {
                if (listener != null) {
                    listener.onError(new SocializeException("No UDID provided"));
                }
            } else {
                this.authenticateAsync(ctx, consumerKey, consumerSecret, udid, advertiserId, authProviderData, listener, sessionConsumer, do3rdPartyAuth);
            }
        }
    }

    @Override
    public SocializeSession authenticateSynchronous(Context context) {
        String consumerKey = this.config.getProperty("socialize.consumer.key");
        String consumerSecret = this.config.getProperty("socialize.consumer.secret");
        try {
            if (this.checkKeys(consumerKey, consumerSecret)) {
                return this.authenticateSynchronous(context, consumerKey, consumerSecret);
            }
            throw new SocializeException("Consumer key and/or secret not provided");
        }
        catch (Exception e) {
            this.logError("Error during synchronous authentication", e);
            return null;
        }
    }

    @Override
    public SocializeSession authenticateSynchronous(Context ctx, String consumerKey, String consumerSecret) throws SocializeException {
        String udid = this.deviceUtils.getUDID(ctx);
        String advertiserId = this.deviceUtils.getAndroidID(ctx);
        SocializeSession session = this.authenticate(ctx, "/authenticate/", consumerKey, consumerSecret, udid, advertiserId);
        return session;
    }

    @Override
    public void saveSession(Context context, SocializeSession session) {
        if (this.sessionPersister != null) {
            this.sessionPersister.save(context, session);
        }
    }

    protected SocializeAuthProviderInfo newSocializeAuthProviderInfo() {
        return new SocializeAuthProviderInfo();
    }

    @Override
    public void getUser(SocializeSession session, long id, UserListener listener) {
        this.getAsync(session, "/user/", String.valueOf(id), listener);
    }

    @Override
    public void saveUserSettings(Context context, SocializeSession session, UserSettings settingsToBeSaved, UserListener listener) {
        User sessionUser = session.getUser();
        UserSettings sessionSettings = session.getUserSettings();
        boolean wasNotificationsEnabled = sessionSettings.isNotificationsEnabled();
        sessionUser.setFirstName(settingsToBeSaved.getFirstName());
        sessionUser.setLastName(settingsToBeSaved.getLastName());
        sessionSettings.update(settingsToBeSaved);
        boolean isNotificationsEnabled = sessionSettings.isNotificationsEnabled();
        if (settingsToBeSaved.getImage() != null) {
            sessionUser.setProfilePicData(this.bitmapUtils.encode(settingsToBeSaved.getImage()));
        }
        if (isNotificationsEnabled && !wasNotificationsEnabled && this.notificationRegistrationSystem != null) {
            this.notificationRegistrationSystem.registerC2DMAsync(context);
        }
        this.saveUserAsync(context, session, sessionUser, listener);
    }

    @Override
    public void saveUserAsync(final Context context, final SocializeSession session, User userToBeSaved, final UserListener listener) {
        final UserSettings settings = session.getUserSettings();
        settings.update(userToBeSaved);
        String endpoint = "/user/" + userToBeSaved.getId() + "/";
        this.putAsPostAsync(session, endpoint, userToBeSaved, new UserSaveListener(){

            @Override
            public void onError(SocializeException error) {
                listener.onError(error);
            }

            @Override
            public void onUpdate(User savedUser) {
                SocializeUserSystem.this.handleUserUpdate(context, session, savedUser, settings, listener);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUserUpdate(Context context, SocializeSession session, User savedUser, UserSettings userSettings, UserListener listener) {
        try {
            SessionLock.lock();
            User sessionUser = session.getUser();
            sessionUser.update(savedUser);
            if (this.sessionPersister != null) {
                this.sessionPersister.saveUser(context, sessionUser, userSettings);
            }
            if (listener != null) {
                listener.onUpdate(sessionUser);
            }
        }
        finally {
            SessionLock.unlock();
        }
    }

    protected boolean checkKeys(String consumerKey, String consumerSecret) {
        return this.checkKeys(consumerKey, consumerSecret, null);
    }

    protected boolean checkKeys(String consumerKey, String consumerSecret, SocializeAuthListener authListener) {
        return this.checkKey("consumer key", consumerKey, authListener) && this.checkKey("consumer secret", consumerSecret, authListener);
    }

    protected boolean checkKey(String name, String key, SocializeAuthListener authListener) {
        if (StringUtils.isEmpty(key)) {
            String msg = "No key specified in authenticate";
            if (authListener != null) {
                authListener.onError(new SocializeException(msg));
            }
            this.logErrorMessage(msg);
            return false;
        }
        return true;
    }

    protected void logError(String message, Throwable error) {
        if (this.logger != null) {
            this.logger.error(message, error);
        } else {
            SocializeLogger.e(error.getMessage(), error);
        }
    }

    protected void logErrorMessage(String message) {
        if (this.logger != null) {
            this.logger.error(message);
        } else {
            System.err.println(message);
        }
    }

    public void setSessionPersister(SocializeSessionPersister sessionPersister) {
        this.sessionPersister = sessionPersister;
    }

    public void setAuthProviderDataFactory(IBeanFactory<AuthProviderData> authProviderDataFactory) {
        this.authProviderDataFactory = authProviderDataFactory;
    }

    public void setDeviceUtils(DeviceUtils deviceUtils) {
        this.deviceUtils = deviceUtils;
    }

    @Override
    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    @Override
    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setAuthProviderInfoBuilder(AuthProviderInfoBuilder authProviderInfoBuilder) {
        this.authProviderInfoBuilder = authProviderInfoBuilder;
    }

    public void setSocializeAuthProviderInfoFactory(SocializeAuthProviderInfoFactory socializeAuthProviderInfoFactory) {
        this.socializeAuthProviderInfoFactory = socializeAuthProviderInfoFactory;
    }

    public void setNotificationRegistrationSystem(NotificationRegistrationSystem notificationRegistrationSystem) {
        this.notificationRegistrationSystem = notificationRegistrationSystem;
    }

    public void setBitmapUtils(BitmapUtils bitmapUtils) {
        this.bitmapUtils = bitmapUtils;
    }
}

