/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api.action.share;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.location.Location;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.ShareType;
import com.socialize.api.action.SocializeActionUtilsBase;
import com.socialize.api.action.share.ShareOptions;
import com.socialize.api.action.share.ShareSystem;
import com.socialize.api.action.share.ShareUtilsProxy;
import com.socialize.api.action.share.SimpleShareListener;
import com.socialize.api.action.share.SocialNetworkShareListener;
import com.socialize.entity.Entity;
import com.socialize.entity.Share;
import com.socialize.entity.User;
import com.socialize.error.SocializeException;
import com.socialize.listener.share.ShareAddListener;
import com.socialize.listener.share.ShareGetListener;
import com.socialize.listener.share.ShareListListener;
import com.socialize.listener.share.ShareListener;
import com.socialize.networks.PostData;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.ui.auth.AuthDialogListener;
import com.socialize.ui.auth.AuthPanelView;
import com.socialize.ui.auth.IAuthDialogFactory;
import com.socialize.ui.dialog.SafeProgressDialog;
import com.socialize.ui.share.DialogFlowController;
import com.socialize.ui.share.IShareDialogFactory;
import com.socialize.ui.share.ShareDialogListener;
import com.socialize.ui.share.SharePanelView;
import org.json.JSONObject;

public class SocializeShareUtils
extends SocializeActionUtilsBase
implements ShareUtilsProxy {
    private ShareSystem shareSystem;
    private IShareDialogFactory shareDialogFactory;
    private IAuthDialogFactory authDialogFactory;

    @Override
    public ShareOptions getUserShareOptions(Context context) {
        ShareOptions options = new ShareOptions();
        this.populateActionOptions(context, options);
        return options;
    }

    @Override
    public void showLinkDialog(Activity context, AuthDialogListener listener) {
        this.authDialogFactory.show((Context)context, listener, !this.config.isAllowSkipAuthOnAllActions());
    }

    @Override
    public void preloadShareDialog(Activity context) {
        this.shareDialogFactory.preload((Context)context);
    }

    @Override
    public void preloadLinkDialog(Activity context) {
        this.authDialogFactory.preload((Context)context);
    }

    @Override
    public void showShareDialog(final Activity context, final Entity entity, int options, final SocialNetworkShareListener socialNetworkListener, final ShareDialogListener dialogListener) {
        this.shareDialogFactory.show((Context)context, entity, socialNetworkListener, new ShareDialogListener(){
            SharePanelView dialogView;

            @Override
            public void onCancel(Dialog dialog) {
                if (dialogListener != null) {
                    dialogListener.onCancel(dialog);
                }
            }

            @Override
            public void onShow(Dialog dialog, SharePanelView dialogView) {
                if (dialogListener != null) {
                    dialogListener.onShow(dialog, dialogView);
                }
                this.dialogView = dialogView;
            }

            @Override
            public void onSimpleShare(ShareType type) {
                if (dialogListener != null) {
                    dialogListener.onSimpleShare(type);
                }
            }

            @Override
            public void onFlowInterrupted(DialogFlowController controller) {
            }

            @Override
            public boolean onContinue(final Dialog dialog, boolean remember, final SocialNetwork ... networks) {
                boolean consumed = false;
                if (dialogListener != null) {
                    consumed = dialogListener.onContinue(dialog, remember, networks);
                }
                if (!consumed) {
                    SocializeShareUtils.this.doShare(dialog, context, entity, socialNetworkListener, networks);
                } else {
                    dialogListener.onFlowInterrupted(new DialogFlowController(){

                        @Override
                        public void onContinue(String text) {
                            ShareOptions options = new ShareOptions();
                            options.setText(text);
                            SocializeShareUtils.this.doShare(dialog, context, entity, socialNetworkListener, options, networks);
                        }

                        @Override
                        public void onCancel() {
                            if (dialogView != null) {
                                dialogView.getContinueButton().setEnabled(true);
                            }
                            dialogListener.onCancel(dialog);
                        }
                    });
                }
                return false;
            }
        }, options);
    }

    protected void doShare(Activity context, Entity entity, SocialNetworkShareListener socialNetworkListener, ShareOptions shareOptions, SocialNetwork ... networks) {
        this.doShare(null, context, entity, socialNetworkListener, shareOptions, networks);
    }

    protected void doShare(Dialog dialog, Activity context, Entity entity, SocialNetworkShareListener socialNetworkListener, SocialNetwork ... networks) {
        this.doShare(dialog, context, entity, socialNetworkListener, (ShareOptions)null, networks);
    }

    protected void doShare(final Dialog dialog, final Activity context, Entity entity, final SocialNetworkShareListener socialNetworkListener, ShareOptions shareOptions, final SocialNetwork ... networks) {
        final SafeProgressDialog progress = SafeProgressDialog.show((Context)context);
        ShareType shareType = ShareType.OTHER;
        if (networks != null && networks.length == 1) {
            shareType = ShareType.valueOf(networks[0]);
        }
        String text = null;
        if (shareOptions != null) {
            text = shareOptions.getText();
        }
        if (text == null) {
            text = "";
        }
        final String fText = text;
        this.shareSystem.addShare((Context)context, this.getSocialize().getSession(), entity, text, shareType, new ShareAddListener(){

            @Override
            public void onError(SocializeException error) {
                if (socialNetworkListener != null) {
                    socialNetworkListener.onError(error);
                }
                progress.dismiss();
                if (dialog != null) {
                    dialog.dismiss();
                }
            }

            @Override
            public void onCreate(Share share) {
                if (socialNetworkListener != null) {
                    socialNetworkListener.onCreate(share);
                }
                if (share != null && SocializeShareUtils.this.shareSystem != null && networks != null && networks.length > 0) {
                    for (SocialNetwork network : networks) {
                        SocializeShareUtils.this.shareSystem.share(context, SocializeShareUtils.this.getSocialize().getSession(), share, fText, null, ShareType.valueOf(network), socialNetworkListener);
                    }
                }
                progress.dismiss();
                if (dialog != null) {
                    dialog.dismiss();
                }
            }
        }, networks);
    }

    @Override
    public void registerShare(Activity context, Entity entity, ShareOptions shareOptions, ShareAddListener listener, SocialNetwork ... networks) {
        String text = null;
        if (shareOptions != null) {
            text = shareOptions.getText();
        }
        if (text == null) {
            text = "";
        }
        ShareType shareType = ShareType.OTHER;
        if (networks != null && networks.length > 0 && networks.length == 1) {
            shareType = ShareType.valueOf(networks[0]);
        }
        this.shareSystem.addShare((Context)context, this.getSocialize().getSession(), entity, text, shareType, listener, networks);
    }

    @Override
    public void shareViaEmail(Activity context, Entity entity, ShareAddListener listener) {
        this.doShare(context, entity, ShareType.EMAIL, listener);
    }

    @Override
    public void shareViaGooglePlus(Activity context, Entity entity, ShareAddListener listener) {
        this.doShare(context, entity, ShareType.GOOGLE_PLUS, listener);
    }

    @Override
    public void shareViaOther(Activity context, Entity entity, ShareAddListener listener) {
        this.doShare(context, entity, ShareType.OTHER, listener);
    }

    @Override
    public void shareViaSMS(Activity context, Entity entity, ShareAddListener listener) {
        this.doShare(context, entity, ShareType.SMS, listener);
    }

    protected void doShare(final Activity context, Entity entity, final ShareType shareType, final ShareAddListener shareAddListener) {
        final SocializeSession session = this.getSocialize().getSession();
        this.shareSystem.addShare((Context)context, session, entity, "", shareType, null, (ShareListener)new ShareAddListener(){

            @Override
            public void onError(SocializeException error) {
                if (shareAddListener != null) {
                    shareAddListener.onError(error);
                }
            }

            @Override
            public void onCreate(Share share) {
                if (share != null && SocializeShareUtils.this.shareSystem != null) {
                    SocializeShareUtils.this.handleNonNetworkShare(context, session, shareType, share, "", null, shareAddListener);
                }
            }
        });
    }

    protected void handleNonNetworkShare(Activity activity, SocializeSession session, ShareType shareType, final Share share, String shareText, Location location, final ShareAddListener shareAddListener) {
        SocialNetworkListener snListener = new SocialNetworkListener(){

            @Override
            public void onNetworkError(Activity context, SocialNetwork network, Exception error) {
                if (shareAddListener != null) {
                    shareAddListener.onError(SocializeException.wrap(error));
                }
            }

            @Override
            public void onCancel() {
                if (shareAddListener != null) {
                    shareAddListener.onCancel();
                }
            }

            @Override
            public boolean onBeforePost(Activity parent, SocialNetwork socialNetwork, PostData postData) {
                return shareAddListener instanceof SocialNetworkListener && ((SimpleShareListener)shareAddListener).onBeforePost(parent, socialNetwork, postData);
            }

            @Override
            public void onAfterPost(Activity parent, SocialNetwork socialNetwork, JSONObject responseObject) {
                if (shareAddListener != null) {
                    shareAddListener.onCreate(share);
                }
            }
        };
        this.shareSystem.share(activity, session, share, shareText, location, shareType, snListener);
    }

    @Override
    public void shareViaSocialNetworks(Activity context, final Entity entity, final ShareOptions shareOptions, final SocialNetworkShareListener listener, final SocialNetwork ... networks) {
        SocializeSession session = this.getSocialize().getSession();
        if (this.isDisplayAuthDialog((Context)context, session, shareOptions, networks)) {
            this.authDialogFactory.show((Context)context, new AuthDialogListener(){

                @Override
                public void onShow(Dialog dialog, AuthPanelView dialogView) {
                }

                @Override
                public void onCancel(Dialog dialog) {
                    if (listener != null) {
                        listener.onCancel();
                    }
                }

                @Override
                public void onSkipAuth(Activity context, Dialog dialog) {
                    dialog.dismiss();
                    SocializeShareUtils.this.doShare(context, entity, listener, shareOptions, networks);
                }

                @Override
                public void onError(Activity context, Dialog dialog, Exception error) {
                    dialog.dismiss();
                    if (listener != null) {
                        listener.onError(SocializeException.wrap(error));
                    }
                }

                @Override
                public void onAuthenticate(Activity context, Dialog dialog, SocialNetwork network) {
                    dialog.dismiss();
                    SocializeShareUtils.this.doShare(context, entity, listener, shareOptions, network);
                }
            }, !this.config.isAllowSkipAuthOnAllActions());
        } else {
            this.doShare(context, entity, listener, shareOptions, networks);
        }
    }

    @Override
    public void getShare(Activity context, ShareGetListener listener, long id) {
        this.shareSystem.getShare(this.getSocialize().getSession(), id, listener);
    }

    @Override
    public void getShares(Activity context, ShareListListener listener, long ... ids) {
        this.shareSystem.getSharesById(this.getSocialize().getSession(), listener, ids);
    }

    @Override
    public void getSharesByUser(Activity context, User user, int start, int end, ShareListListener listener) {
        this.shareSystem.getSharesByUser(this.getSocialize().getSession(), user.getId(), start, end, listener);
    }

    @Override
    public void getSharesByEntity(Activity context, String entityKey, int start, int end, ShareListListener listener) {
        this.shareSystem.getSharesByEntity(this.getSocialize().getSession(), entityKey, start, end, listener);
    }

    @Override
    public void getSharesByApplication(Activity context, int start, int end, ShareListListener listener) {
        this.shareSystem.getSharesByApplication(this.getSocialize().getSession(), start, end, listener);
    }

    @Override
    public boolean canShareViaEmail(Activity context) {
        return this.getSocialize().canShare((Context)context, ShareType.EMAIL);
    }

    @Override
    public boolean canShareViaSMS(Activity context) {
        return this.getSocialize().canShare((Context)context, ShareType.SMS);
    }

    public void setShareSystem(ShareSystem shareSystem) {
        this.shareSystem = shareSystem;
    }

    public void setShareDialogFactory(IShareDialogFactory shareDialogFactory) {
        this.shareDialogFactory = shareDialogFactory;
    }

    public void setAuthDialogFactory(IAuthDialogFactory authDialogFactory) {
        this.authDialogFactory = authDialogFactory;
    }
}

