/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api.action.entity;

import android.app.Activity;
import android.content.Context;
import com.socialize.EntityUtils;
import com.socialize.Socialize;
import com.socialize.api.action.entity.EntitySystem;
import com.socialize.api.action.entity.EntityUtilsProxy;
import com.socialize.entity.Entity;
import com.socialize.error.SocializeException;
import com.socialize.listener.entity.EntityAddListener;
import com.socialize.listener.entity.EntityGetListener;
import com.socialize.listener.entity.EntityListListener;
import com.socialize.listener.entity.EntityListener;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.SocializeEntityLoader;
import com.socialize.util.DefaultAppUtils;
import com.socialize.util.EntityLoaderUtils;

public class SocializeEntityUtils
implements EntityUtilsProxy {
    private EntitySystem entitySystem;
    private EntityLoaderUtils entityLoaderUtils;
    private SocializeLogger logger;

    @Override
    public void getEntity(Activity context, long id, EntityGetListener listener) {
        this.entitySystem.getEntity(Socialize.getSocialize().getSession(), id, (EntityListener)listener);
    }

    @Override
    public void saveEntity(Activity context, Entity e, EntityAddListener listener) {
        this.entitySystem.addEntity(Socialize.getSocialize().getSession(), e, listener);
    }

    @Override
    public void getEntity(Activity context, String key, EntityGetListener listener) {
        this.entitySystem.getEntity(Socialize.getSocialize().getSession(), key, (EntityListener)listener);
    }

    @Override
    public void getEntities(Activity context, int start, int end, EntityUtils.SortOrder sortOrder, EntityListListener listener) {
        this.entitySystem.getEntities(Socialize.getSocialize().getSession(), start, end, sortOrder, listener);
    }

    @Override
    public void getEntities(Activity context, EntityUtils.SortOrder sortOrder, EntityListListener listener, String ... keys) {
        this.entitySystem.getEntities(Socialize.getSocialize().getSession(), sortOrder, listener, keys);
    }

    public void setEntitySystem(EntitySystem entitySystem) {
        this.entitySystem = entitySystem;
    }

    public void setEntityLoaderUtils(EntityLoaderUtils entityLoaderUtils) {
        this.entityLoaderUtils = entityLoaderUtils;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    @Override
    public void showEntity(final Activity context, String key, final EntityGetListener listener) {
        this.getEntity(context, key, new EntityGetListener(){

            @Override
            public void onGet(Entity entity) {
                SocializeEntityUtils.this.showEntity(context, entity, listener);
            }

            @Override
            public void onError(SocializeException error) {
                if (listener != null) {
                    listener.onError(error);
                }
            }
        });
    }

    @Override
    public void showEntity(final Activity context, long id, final EntityGetListener listener) {
        this.getEntity(context, id, new EntityGetListener(){

            @Override
            public void onGet(Entity entity) {
                SocializeEntityUtils.this.showEntity(context, entity, listener);
            }

            @Override
            public void onError(SocializeException error) {
                if (listener != null) {
                    listener.onError(error);
                }
            }
        });
    }

    protected void showEntity(Activity context, Entity entity, EntityGetListener listener) {
        SocializeEntityLoader entityLoader = this.entityLoaderUtils.initEntityLoader();
        if (entityLoader != null) {
            if (entityLoader.canLoad((Context)context, entity)) {
                entityLoader.loadEntity(context, entity);
            } else {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("Entity loader indicates that entity with key [" + entity.getKey() + "] cannot be loaded.  Redirecting to home activity");
                }
                DefaultAppUtils.launchMainApp(context);
            }
        } else if (listener != null) {
            listener.onError(new SocializeException("No entity loader defined"));
        }
    }
}

