/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api.action.comment;

import android.app.Activity;
import com.socialize.api.action.SocializeActionUtilsBase;
import com.socialize.api.action.comment.SubscriptionSystem;
import com.socialize.api.action.comment.SubscriptionUtilsProxy;
import com.socialize.entity.Entity;
import com.socialize.entity.ListResult;
import com.socialize.entity.Subscription;
import com.socialize.error.SocializeException;
import com.socialize.listener.subscription.SubscriptionCheckListener;
import com.socialize.listener.subscription.SubscriptionGetListener;
import com.socialize.listener.subscription.SubscriptionResultListener;
import com.socialize.notifications.NotificationType;
import com.socialize.notifications.SubscriptionType;
import java.util.List;

public class SocializeSubscriptionUtils
extends SocializeActionUtilsBase
implements SubscriptionUtilsProxy {
    private SubscriptionSystem subscriptionSystem;

    @Override
    public void subscribe(Activity context, Entity e, SubscriptionType type, SubscriptionResultListener listener) {
        this.subscriptionSystem.addSubscription(this.getSocialize().getSession(), e, NotificationType.valueOf(type), listener);
    }

    @Override
    public void unsubscribe(Activity context, Entity e, SubscriptionType type, SubscriptionResultListener listener) {
        this.subscriptionSystem.removeSubscription(this.getSocialize().getSession(), e, NotificationType.valueOf(type), listener);
    }

    @Override
    public void isSubscribed(Activity context, Entity e, SubscriptionType type, final SubscriptionCheckListener listener) {
        final NotificationType nType = NotificationType.valueOf(type);
        this.subscriptionSystem.getSubscription(this.getSocialize().getSession(), e, NotificationType.valueOf(type), new SubscriptionGetListener(){

            @Override
            public void onList(ListResult<Subscription> result) {
                if (listener != null) {
                    List<Subscription> items = result.getItems();
                    if (items == null || items.size() == 0) {
                        listener.onNotSubscribed();
                    }
                    boolean matched = false;
                    for (Subscription subscription : items) {
                        if (!subscription.getNotificationType().equals((Object)nType)) continue;
                        matched = true;
                        if (subscription.isSubscribed()) {
                            listener.onSubscribed(subscription);
                            break;
                        }
                        listener.onNotSubscribed();
                        break;
                    }
                    if (!matched) {
                        listener.onNotSubscribed();
                    }
                }
            }

            @Override
            public void onError(SocializeException error) {
                if (listener != null) {
                    listener.onError(error);
                }
            }
        });
    }

    public void setSubscriptionSystem(SubscriptionSystem subscriptionSystem) {
        this.subscriptionSystem = subscriptionSystem;
    }
}

