/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api.action.comment;

import com.socialize.api.SocializeApi;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.comment.CommentOptions;
import com.socialize.api.action.comment.CommentSystem;
import com.socialize.entity.Comment;
import com.socialize.entity.Entity;
import com.socialize.listener.SocializeActionListener;
import com.socialize.listener.comment.CommentListener;
import com.socialize.networks.SocialNetwork;
import com.socialize.provider.SocializeProvider;
import java.util.ArrayList;

public class SocializeCommentSystem
extends SocializeApi<Comment, SocializeProvider<Comment>>
implements CommentSystem {
    public SocializeCommentSystem(SocializeProvider<Comment> provider) {
        super(provider);
    }

    @Override
    public void addComment(SocializeSession session, Comment comment, CommentOptions commentOptions, CommentListener listener, SocialNetwork ... networks) {
        if (commentOptions != null) {
            comment.setNotificationsEnabled(commentOptions.isSubscribeToUpdates());
        }
        this.setPropagationData(comment, commentOptions, networks);
        this.setLocation(comment);
        ArrayList<Comment> list = new ArrayList<Comment>(1);
        list.add(comment);
        this.postAsync(session, "/comment/", list, (SocializeActionListener)listener);
    }

    @Override
    public void deleteComment(SocializeSession session, long id, CommentListener listener) {
        this.deleteAsync(session, "/comment/", String.valueOf(id), listener);
    }

    @Override
    public void addComment(SocializeSession session, Entity entity, String comment, CommentOptions commentOptions, CommentListener listener, SocialNetwork ... networks) {
        Comment c = new Comment();
        c.setText(comment);
        c.setEntitySafe(entity);
        this.addComment(session, c, commentOptions, listener, networks);
    }

    @Override
    public void getCommentsByEntity(SocializeSession session, String key, CommentListener listener) {
        this.listAsync(session, "/comment/", key, listener, new String[0]);
    }

    @Override
    public void getCommentsByEntity(SocializeSession session, String key, int startIndex, int endIndex, CommentListener listener) {
        this.listAsync(session, "/comment/", key, null, null, startIndex, endIndex, listener, new String[0]);
    }

    @Override
    public void getCommentsByApplication(SocializeSession session, int startIndex, int endIndex, CommentListener listener) {
        this.listAsync(session, "/comment/", null, null, null, startIndex, endIndex, listener, new String[0]);
    }

    @Override
    public void getCommentsByUser(SocializeSession session, long userId, CommentListener listener) {
        String endpoint = "/user/" + userId + "/comment/";
        this.listAsync(session, endpoint, listener);
    }

    @Override
    public void getCommentsByUser(SocializeSession session, long userId, int startIndex, int endIndex, CommentListener listener) {
        String endpoint = "/user/" + userId + "/comment/";
        this.listAsync(session, endpoint, startIndex, endIndex, listener);
    }

    @Override
    public void getCommentsById(SocializeSession session, CommentListener listener, long ... ids) {
        String[] strIds = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            strIds[i] = String.valueOf(ids[i]);
        }
        this.listAsync(session, "/comment/", null, 0, 100, listener, strIds);
    }

    @Override
    public void getComment(SocializeSession session, long id, CommentListener listener) {
        this.getAsync(session, "/comment/", String.valueOf(id), listener);
    }
}

