/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api.action;

import com.socialize.networks.SocialNetwork;

public enum ShareType {
    TWITTER("twitter", "Twitter", 1),
    FACEBOOK("facebook", "Facebook", 2),
    EMAIL("email", "Email", 3),
    SMS("sms", "SMS", 4),
    GOOGLE_PLUS("google_plus", "Google+", 101),
    OTHER("other", "Other", 101);

    private final String name;
    private final String displayName;
    private final int id;

    private ShareType(String name, String displayName, int id) {
        this.name = name;
        this.displayName = displayName;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }

    public static ShareType valueOf(SocialNetwork socialNetwork) {
        if (socialNetwork == null) {
            return OTHER;
        }
        return ShareType.valueOf(socialNetwork.name().toUpperCase());
    }

    public static ShareType valueOf(int id) {
        switch (id) {
            case 1: {
                return TWITTER;
            }
            case 2: {
                return FACEBOOK;
            }
            case 3: {
                return EMAIL;
            }
            case 4: {
                return SMS;
            }
        }
        return OTHER;
    }
}

