/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api;

import android.content.Context;
import android.content.SharedPreferences;
import com.socialize.api.SocializeSession;
import com.socialize.api.SocializeSessionFactory;
import com.socialize.api.SocializeSessionPersister;
import com.socialize.api.WritableSession;
import com.socialize.auth.AuthProviderType;
import com.socialize.auth.DefaultUserProviderCredentials;
import com.socialize.auth.DefaultUserProviderCredentialsMap;
import com.socialize.auth.SocializeAuthProviderInfo;
import com.socialize.auth.UserProviderCredentials;
import com.socialize.auth.UserProviderCredentialsMap;
import com.socialize.auth.facebook.FacebookAuthProviderInfo;
import com.socialize.entity.User;
import com.socialize.entity.UserFactory;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.profile.UserSettings;
import com.socialize.ui.profile.UserSettingsFactory;
import com.socialize.util.JSONUtils;
import com.socialize.util.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class PreferenceSessionPersister
implements SocializeSessionPersister {
    private static final String PREFERENCES = "SocializeSession";
    private static final String SOCIALIZE_VERSION = "socialize_version";
    private static final String USER_AUTH_DATA = "user_auth_data";
    private UserFactory userFactory;
    private UserSettingsFactory userSettingsFactory;
    private SocializeSessionFactory sessionFactory;
    private SocializeLogger logger = null;
    private JSONUtils jsonUtils;

    public PreferenceSessionPersister() {
    }

    public PreferenceSessionPersister(UserFactory userFactory, SocializeSessionFactory sessionFactory) {
        this.userFactory = userFactory;
        this.sessionFactory = sessionFactory;
    }

    @Override
    public synchronized void saveUser(Context context, User user, UserSettings userSettings) {
        SharedPreferences prefs = context.getSharedPreferences(PREFERENCES, 0);
        SharedPreferences.Editor editor = prefs.edit();
        this.saveUser(editor, user, userSettings);
        editor.commit();
    }

    @Override
    public void saveUserSettingsAsync(final Context context, final UserSettings settings) {
        new Thread(){

            @Override
            public void run() {
                SharedPreferences prefs = context.getSharedPreferences(PreferenceSessionPersister.PREFERENCES, 0);
                SharedPreferences.Editor editor = prefs.edit();
                try {
                    String userJSON = PreferenceSessionPersister.this.userSettingsFactory.toJSON(settings).toString();
                    editor.putString("user-settings", userJSON);
                    editor.commit();
                }
                catch (JSONException e) {
                    if (PreferenceSessionPersister.this.logger != null) {
                        PreferenceSessionPersister.this.logger.error("Failed to serialize user settings object", (Throwable)e);
                    }
                    SocializeLogger.e("Failed to serialize user settings object", e);
                }
            }
        }.start();
    }

    public synchronized void saveUser(SharedPreferences.Editor editor, User user, UserSettings userSettings) {
        if (user != null) {
            String userJSON;
            try {
                userJSON = this.userFactory.toJSON(user).toString();
                editor.putString("user", userJSON);
            }
            catch (JSONException e) {
                if (this.logger != null) {
                    this.logger.error("Failed to serialize user object", (Throwable)e);
                }
                SocializeLogger.e("Failed to serialize user object", e);
            }
            if (userSettings == null) {
                userSettings = this.createSettingsLegacy(user);
            }
            try {
                userJSON = this.userSettingsFactory.toJSON(userSettings).toString();
                editor.putString("user-settings", userJSON);
            }
            catch (JSONException e) {
                if (this.logger != null) {
                    this.logger.error("Failed to serialize user settings object", (Throwable)e);
                }
                SocializeLogger.e("Failed to serialize user settings object", e);
            }
        }
    }

    @Override
    public synchronized void delete(Context context, AuthProviderType type) {
        SharedPreferences prefs = context.getSharedPreferences(PREFERENCES, 0);
        String authData = prefs.getString(USER_AUTH_DATA, null);
        SharedPreferences.Editor editor = prefs.edit();
        if (!StringUtils.isEmpty(authData)) {
            UserProviderCredentialsMap map = this.jsonUtils.fromJSON(authData, UserProviderCredentialsMap.class);
            map.remove(type);
            editor.putString(USER_AUTH_DATA, this.jsonUtils.toJSON(map));
        } else {
            editor.putString(USER_AUTH_DATA, this.jsonUtils.toJSON(this.makeDefaultUserProviderCredentials()));
        }
        editor.commit();
    }

    protected UserProviderCredentials makeDefaultUserProviderCredentials() {
        DefaultUserProviderCredentials userProviderCredentials = this.newDefaultUserProviderCredentials();
        SocializeAuthProviderInfo info = new SocializeAuthProviderInfo();
        userProviderCredentials.setAuthProviderInfo(info);
        return userProviderCredentials;
    }

    @Override
    public synchronized void save(Context context, SocializeSession session) {
        SharedPreferences prefs = context.getSharedPreferences(PREFERENCES, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("consumer_key", session.getConsumerKey());
        editor.putString("consumer_secret", session.getConsumerSecret());
        editor.putString("consumer_token", session.getConsumerToken());
        editor.putString("consumer_token_secret", session.getConsumerTokenSecret());
        editor.putString(SOCIALIZE_VERSION, "3.1.5");
        String userProviderCredentials = this.jsonUtils.toJSON(session.getUserProviderCredentials());
        editor.putString(USER_AUTH_DATA, userProviderCredentials);
        User user = session.getUser();
        UserSettings settings = session.getUserSettings();
        this.saveUser(editor, user, settings);
        editor.commit();
    }

    protected UserSettings createSettingsLegacy(User user) {
        UserSettings userSettings = new UserSettings();
        userSettings.setAutoPostFacebook(user.isAutoPostToFacebook());
        userSettings.setAutoPostTwitter(user.isAutoPostToTwitter());
        userSettings.setFirstName(user.getFirstName());
        userSettings.setLastName(user.getLastName());
        userSettings.setLocationEnabled(user.isShareLocation());
        userSettings.setNotificationsEnabled(user.isNotificationsEnabled());
        return userSettings;
    }

    protected UserProviderCredentialsMap loadUserProviderCredentials(SharedPreferences prefs) {
        String authData = prefs.getString(USER_AUTH_DATA, null);
        UserProviderCredentialsMap map = null;
        if (StringUtils.isEmpty(authData)) {
            String userId3rdParty = prefs.getString("3rd_party_userid", null);
            String token3rdParty = prefs.getString("3rd_party_token", null);
            int iProviderType = prefs.getInt("3rd_party_type", AuthProviderType.SOCIALIZE.getId());
            AuthProviderType type = AuthProviderType.valueOf(iProviderType);
            map = this.newDefaultUserProviderCredentialsMap();
            if (type.equals((Object)AuthProviderType.FACEBOOK)) {
                DefaultUserProviderCredentials data = this.newDefaultUserProviderCredentials();
                String appId3rdParty = prefs.getString("3rd_party_app_id", null);
                data.setAccessToken(token3rdParty);
                data.setUserId(userId3rdParty);
                FacebookAuthProviderInfo info = new FacebookAuthProviderInfo();
                info.setAppId(appId3rdParty);
                data.setAuthProviderInfo(info);
                map.put(type, data);
            } else if (!type.equals((Object)AuthProviderType.SOCIALIZE)) {
                if (this.logger != null) {
                    this.logger.warn("Unexpected auth type [" + (Object)((Object)type) + "].  Legacy session loading only supports [" + (Object)((Object)AuthProviderType.FACEBOOK) + "] or [" + (Object)((Object)AuthProviderType.SOCIALIZE) + "].");
                }
                type = AuthProviderType.SOCIALIZE;
            }
            SocializeAuthProviderInfo info = new SocializeAuthProviderInfo();
            DefaultUserProviderCredentials data = this.newDefaultUserProviderCredentials();
            data.setAuthProviderInfo(info);
            map.put(AuthProviderType.SOCIALIZE, data);
        } else {
            map = this.jsonUtils.fromJSON(authData, UserProviderCredentialsMap.class);
        }
        return map;
    }

    protected DefaultUserProviderCredentials newDefaultUserProviderCredentials() {
        return new DefaultUserProviderCredentials();
    }

    protected DefaultUserProviderCredentialsMap newDefaultUserProviderCredentialsMap() {
        return new DefaultUserProviderCredentialsMap();
    }

    @Override
    public synchronized WritableSession load(Context context) {
        WritableSession session;
        block11: {
            String userSettingsJson;
            SharedPreferences prefs = context.getSharedPreferences(PREFERENCES, 0);
            String key = prefs.getString("consumer_key", null);
            String secret = prefs.getString("consumer_secret", null);
            UserProviderCredentialsMap userProviderCredentials = this.loadUserProviderCredentials(prefs);
            session = this.sessionFactory.create(key, secret, userProviderCredentials);
            session.setRestored(true);
            String oauth_token = prefs.getString("consumer_token", null);
            String oauth_token_secret = prefs.getString("consumer_token_secret", null);
            if (StringUtils.isEmpty(oauth_token) || StringUtils.isEmpty(oauth_token_secret)) {
                return null;
            }
            session.setConsumerToken(oauth_token);
            session.setConsumerTokenSecret(oauth_token_secret);
            String userJson = prefs.getString("user", null);
            User user = null;
            if (userJson != null) {
                try {
                    JSONObject json = new JSONObject(userJson);
                    user = (User)this.userFactory.fromJSON(json);
                    session.setUser(user);
                }
                catch (JSONException e) {
                    if (this.logger != null) {
                        this.logger.error("Failed to deserialize user object", (Throwable)e);
                    }
                    SocializeLogger.e("Failed to deserialize user object", e);
                }
            }
            if ((userSettingsJson = prefs.getString("user-settings", null)) != null) {
                try {
                    JSONObject json = new JSONObject(userSettingsJson);
                    UserSettings userSettings = (UserSettings)this.userSettingsFactory.fromJSON(json);
                    session.setUserSettings(userSettings);
                }
                catch (JSONException e) {
                    if (this.logger != null) {
                        this.logger.error("Failed to deserialize user settings object", (Throwable)e);
                        break block11;
                    }
                    SocializeLogger.e("Failed to deserialize user settings object", e);
                }
            } else if (user != null) {
                session.setUserSettings(this.createSettingsLegacy(user));
            }
        }
        return session;
    }

    @Override
    public synchronized void delete(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(PREFERENCES, 0);
        prefs.edit().clear().commit();
    }

    public void setUserFactory(UserFactory userFactory) {
        this.userFactory = userFactory;
    }

    public void setSessionFactory(SocializeSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setJsonUtils(JSONUtils jsonUtils) {
        this.jsonUtils = jsonUtils;
    }

    public void setUserSettingsFactory(UserSettingsFactory userSettingsFactory) {
        this.userSettingsFactory = userSettingsFactory;
    }
}

