/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api;

import com.socialize.api.SocializeRequestFactory;
import com.socialize.api.SocializeSession;
import com.socialize.auth.AuthProviderData;
import com.socialize.auth.AuthProviderInfo;
import com.socialize.auth.UserProviderCredentials;
import com.socialize.auth.UserProviderCredentialsMap;
import com.socialize.entity.SocializeObject;
import com.socialize.entity.SocializeObjectFactory;
import com.socialize.error.SocializeException;
import com.socialize.oauth.OAuthRequestSigner;
import com.socialize.oauth.OAuthSignListener;
import com.socialize.util.AppUtils;
import com.socialize.util.StringUtils;
import com.socialize.util.UrlBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

public class DefaultSocializeRequestFactory<T extends SocializeObject>
implements SocializeRequestFactory<T> {
    private OAuthRequestSigner oauthSigner;
    private SocializeObjectFactory<T> objectFactory;
    private OAuthSignListener signListener;
    private AppUtils appUtils;

    public DefaultSocializeRequestFactory(OAuthRequestSigner signer, SocializeObjectFactory<T> objectFactory) {
        this.oauthSigner = signer;
        this.objectFactory = objectFactory;
    }

    public DefaultSocializeRequestFactory() {
    }

    public void setOauthSigner(OAuthRequestSigner signer) {
        this.oauthSigner = signer;
    }

    public void setObjectFactory(SocializeObjectFactory<T> objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setSignListener(OAuthSignListener signListener) {
        this.signListener = signListener;
    }

    public void setAppUtils(AppUtils appUtils) {
        this.appUtils = appUtils;
    }

    @Override
    public HttpUriRequest getAuthRequestWith3rdParty(SocializeSession session, String endpoint, String udid, String advertiserId, UserProviderCredentials userProviderCredentials) throws SocializeException {
        HttpPost post = new HttpPost(endpoint);
        try {
            ArrayList<BasicNameValuePair> data = new ArrayList<BasicNameValuePair>(1);
            JSONObject json = new JSONObject();
            json.put("udid", (Object)udid);
            json.put("a", (Object)advertiserId);
            AuthProviderInfo authProviderInfo = userProviderCredentials.getAuthProviderInfo();
            if (authProviderInfo != null) {
                json.put("auth_type", authProviderInfo.getType().getId());
                if (!StringUtils.isEmpty(userProviderCredentials.getAccessToken())) {
                    json.put("auth_token", (Object)userProviderCredentials.getAccessToken());
                }
                if (!StringUtils.isEmpty(userProviderCredentials.getTokenSecret())) {
                    json.put("auth_token_secret", (Object)userProviderCredentials.getTokenSecret());
                }
                if (!StringUtils.isEmpty(userProviderCredentials.getUserId())) {
                    json.put("auth_id", (Object)userProviderCredentials.getUserId());
                }
            }
            data.add(new BasicNameValuePair("payload", json.toString()));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(data);
            post.setEntity((HttpEntity)entity);
            this.sign(session, post);
        }
        catch (UnsupportedEncodingException e) {
            throw new SocializeException(e);
        }
        catch (JSONException e) {
            throw new SocializeException(e);
        }
        return post;
    }

    @Override
    public HttpUriRequest getAuthRequest(SocializeSession session, String endpoint, String udid, String advertiserId, AuthProviderData data) throws SocializeException {
        UserProviderCredentialsMap userProviderCredentialsMap = session.getUserProviderCredentials();
        if (userProviderCredentialsMap != null) {
            AuthProviderInfo authProviderInfo = data.getAuthProviderInfo();
            if (authProviderInfo != null) {
                UserProviderCredentials userProviderCredentials = userProviderCredentialsMap.get(authProviderInfo.getType());
                return this.getAuthRequestWith3rdParty(session, endpoint, udid, advertiserId, userProviderCredentials);
            }
            throw new SocializeException("No provider info found in stored session");
        }
        throw new SocializeException("No provider credentials found in stored session");
    }

    @Override
    public HttpUriRequest getGetRequest(SocializeSession session, String endpoint, String id) throws SocializeException {
        endpoint = endpoint + URLEncoder.encode(id) + "/";
        return this.getGetRequest(session, endpoint);
    }

    public HttpUriRequest getGetRequest(SocializeSession session, String endpoint) throws SocializeException {
        HttpGet get = this.sign(session, new HttpGet(endpoint));
        return get;
    }

    @Override
    public HttpUriRequest getDeleteRequest(SocializeSession session, String endpoint, String id) throws SocializeException {
        endpoint = endpoint + URLEncoder.encode(id) + "/";
        HttpDelete del = this.sign(session, new HttpDelete(endpoint));
        return del;
    }

    @Override
    public HttpUriRequest getListRequest(SocializeSession session, String endpoint) throws SocializeException {
        return this.getListRequest(session, endpoint, null, null, 0, 100);
    }

    @Override
    public HttpUriRequest getListRequest(SocializeSession session, String endpoint, int startIndex, int endIndex) throws SocializeException {
        return this.getListRequest(session, endpoint, null, null, startIndex, endIndex);
    }

    @Override
    public HttpUriRequest getListRequest(SocializeSession session, String endpoint, String key, String[] ids, String idKey) throws SocializeException {
        return this.getListRequest(session, endpoint, key, ids, idKey, null, 0, 100);
    }

    @Override
    public HttpUriRequest getListRequest(SocializeSession session, String endpoint, String key, String[] ids, String idKey, Map<String, String> extraParams, int startIndex, int endIndex) throws SocializeException {
        UrlBuilder builder = new UrlBuilder();
        builder.start(endpoint);
        if (!StringUtils.isEmpty(key)) {
            builder.addParam("entity_key", key);
        }
        if (ids != null) {
            for (String id : ids) {
                builder.addParam(idKey, id);
            }
        }
        if (endIndex <= 0) {
            endIndex = 100;
        }
        builder.addParam("first", String.valueOf(startIndex));
        builder.addParam("last", String.valueOf(endIndex));
        if (extraParams != null) {
            Set<Map.Entry<String, String>> entrySet = extraParams.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                builder.addParam(entry.getKey(), entry.getValue());
            }
        }
        HttpGet get = new HttpGet(builder.toString());
        this.sign(session, get);
        return get;
    }

    @Override
    public HttpUriRequest getListRequest(SocializeSession session, String endpoint, String key, String[] ids) throws SocializeException {
        return this.getListRequest(session, endpoint, key, ids, 0, 100);
    }

    @Override
    public HttpUriRequest getListRequest(SocializeSession session, String endpoint, String key, String[] ids, int startIndex, int endIndex) throws SocializeException {
        return this.getListRequest(session, endpoint, key, ids, "id", null, startIndex, endIndex);
    }

    @Override
    public HttpUriRequest getPutRequest(SocializeSession session, String endpoint, T entity) throws SocializeException {
        HttpPut put = new HttpPut(endpoint);
        this.populatePutPost(session, (HttpEntityEnclosingRequestBase)put, entity);
        return put;
    }

    @Override
    public HttpUriRequest getPostRequest(SocializeSession session, String endpoint, T entity) throws SocializeException {
        HttpPost post = new HttpPost(endpoint);
        this.populatePutPost(session, (HttpEntityEnclosingRequestBase)post, entity);
        return post;
    }

    @Override
    public HttpUriRequest getPutRequest(SocializeSession session, String endpoint, Collection<T> objects) throws SocializeException {
        HttpPut put = new HttpPut(endpoint);
        this.populatePutPost(session, (HttpEntityEnclosingRequestBase)put, (T)objects);
        return put;
    }

    @Override
    public HttpUriRequest getPostRequest(SocializeSession session, String endpoint, Collection<T> objects) throws SocializeException {
        HttpPost post = new HttpPost(endpoint);
        this.populatePutPost(session, (HttpEntityEnclosingRequestBase)post, (T)objects);
        return post;
    }

    private void populatePutPost(SocializeSession session, HttpEntityEnclosingRequestBase request, Collection<T> objects) throws SocializeException {
        try {
            String payload = this.objectFactory.toJSON(objects).toString();
            this.populatePutPost(session, request, payload);
        }
        catch (JSONException e) {
            throw new SocializeException(e);
        }
    }

    private void populatePutPost(SocializeSession session, HttpEntityEnclosingRequestBase request, T object) throws SocializeException {
        try {
            String payload = this.objectFactory.toJSON(object).toString();
            this.populatePutPost(session, request, payload);
        }
        catch (JSONException e) {
            throw new SocializeException(e);
        }
    }

    private void populatePutPost(SocializeSession session, HttpEntityEnclosingRequestBase request, String payload) throws SocializeException {
        try {
            ArrayList<BasicNameValuePair> data = new ArrayList<BasicNameValuePair>();
            data.add(new BasicNameValuePair("payload", payload));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(data, "UTF-8");
            request.setEntity((HttpEntity)entity);
            this.sign(session, request);
        }
        catch (UnsupportedEncodingException e) {
            throw new SocializeException(e);
        }
    }

    protected <R extends HttpUriRequest> R sign(SocializeSession session, R request) throws SocializeException {
        if (this.appUtils != null) {
            request.addHeader("User-Agent", this.appUtils.getUserAgentString());
        }
        return this.oauthSigner.sign(session, request, this.signListener);
    }
}

