/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins;

import com.soasta.jenkins.AbstractCloudTestBuilderDescriptor;
import com.soasta.jenkins.CloudTestServer;
import com.soasta.jenkins.iOSAppInstallerInstaller;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.logging.Logger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class iOSSimulatorLauncher
extends Builder {
    private final String url;
    private final String cloudTestServerID;
    private final String app;
    private final String sdk;
    private final String family;
    private static final Logger LOGGER = Logger.getLogger(iOSSimulatorLauncher.class.getName());

    @DataBoundConstructor
    public iOSSimulatorLauncher(String url, String cloudTestServerID, String app, String sdk, String family) {
        this.url = url;
        this.cloudTestServerID = cloudTestServerID;
        this.app = app;
        this.sdk = sdk;
        this.family = family;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCloudTestServerID() {
        return this.cloudTestServerID;
    }

    public String getApp() {
        return this.app;
    }

    public String getSdk() {
        return this.sdk;
    }

    public String getFamily() {
        return this.family;
    }

    public CloudTestServer getServer() {
        return CloudTestServer.getByID(this.cloudTestServerID);
    }

    public Object readResolve() throws IOException {
        if (this.cloudTestServerID != null) {
            return this;
        }
        CloudTestServer s = CloudTestServer.getByURL(this.getUrl());
        LOGGER.info("Matched server URL " + this.getUrl() + " to ID: " + s.getId() + "; re-creating.");
        return new iOSSimulatorLauncher(this.url, s.getId(), this.app, this.sdk, this.family);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        int r;
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars envs = build.getEnvironment((TaskListener)listener);
        CloudTestServer server = this.getServer();
        if (server == null) {
            throw new AbortException("No TouchTest server is configured in the system configuration.");
        }
        FilePath bin = new iOSAppInstallerInstaller(server).ios_sim_launcher(build.getBuiltOn(), (TaskListener)listener);
        String cloudTestServerUrl = server.getUrl();
        String agentURL = cloudTestServerUrl.endsWith("/") ? cloudTestServerUrl + "touchtest" : cloudTestServerUrl + "/touchtest";
        args.add((Object)bin).add(new String[]{"--app", envs.expand(this.app)}).add(new String[]{"--agenturl", agentURL});
        if (this.sdk != null && !this.sdk.trim().isEmpty()) {
            args.add(new String[]{"--sdk", envs.expand(this.sdk)});
        }
        if (this.family != null && !this.family.trim().isEmpty()) {
            args.add(new String[]{"--family", envs.expand(this.family)});
        }
        return (r = launcher.launch().cmds(args).pwd(build.getWorkspace()).stdout((TaskListener)listener).join()) == 0;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractCloudTestBuilderDescriptor {
        public String getDisplayName() {
            return "Run App in iOS Simulator";
        }

        public ListBoxModel doFillFamilyItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("iPhone", "iphone");
            items.add("iPhone (Retina)", "iphone_retina");
            items.add("iPad", "ipad");
            items.add("iPad (Retina)", "ipad_retina");
            return items;
        }

        public FormValidation doCheckApp(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"App directory is required.");
            }
            return this.validateFileMask(project, value);
        }
    }
}

