/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins;

import com.soasta.jenkins.AbstractCloudTestBuilderDescriptor;
import com.soasta.jenkins.CloudTestServer;
import com.soasta.jenkins.iOSAppInstallerBase;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.logging.Logger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class iOSAppInstaller
extends iOSAppInstallerBase {
    private final String ipa;
    private static final Logger LOGGER = Logger.getLogger(iOSAppInstaller.class.getName());

    @DataBoundConstructor
    public iOSAppInstaller(String url, String cloudTestServerID, String ipa, String additionalOptions) {
        super(url, cloudTestServerID, additionalOptions);
        this.ipa = ipa;
    }

    public String getIpa() {
        return this.ipa;
    }

    @Override
    protected void addArgs(EnvVars envs, ArgumentListBuilder args) {
        args.add(new String[]{"--ipa", envs.expand(this.ipa)});
    }

    public Object readResolve() throws IOException {
        if (this.getCloudTestServerID() != null) {
            return this;
        }
        CloudTestServer s = CloudTestServer.getByURL(this.getUrl());
        LOGGER.info("Matched server URL " + this.getUrl() + " to ID: " + s.getId() + "; re-creating.");
        return new iOSAppInstaller(this.getUrl(), s.getId(), this.ipa, this.getAdditionalOptions());
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractCloudTestBuilderDescriptor {
        public String getDisplayName() {
            return "Install iOS App on Device";
        }

        public FormValidation doCheckIpa(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"IPA file is required.");
            }
            return this.validateFileMask(project, value);
        }
    }
}

