/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins.cloud.postbuild;

import com.soasta.jenkins.CloudTestServer;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import javax.inject.Inject;
import org.kohsuke.stapler.QueryParameter;

public abstract class AbstractCloudCommandPostBuildDescriptor
extends BuildStepDescriptor<Publisher> {
    @Inject
    CloudTestServer.DescriptorImpl serverDescriptor;

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public FormValidation doCheckName(@QueryParameter String value) {
        if (value == null || value.trim().isEmpty()) {
            return FormValidation.error((String)"Name is Required");
        }
        return FormValidation.ok();
    }

    public ListBoxModel doFillCloudTestServerIDItems() {
        ListBoxModel r = new ListBoxModel();
        for (CloudTestServer s : this.serverDescriptor.getServers()) {
            r.add(s.getName(), s.getId());
        }
        return r;
    }

    protected FormValidation validateFileMask(AbstractProject project, String value) throws IOException {
        if (value.contains("${")) {
            return FormValidation.ok();
        }
        return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
    }
}

