/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins;

import com.soasta.jenkins.JunitResultAction;
import com.soasta.jenkins.Message;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestAction;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestObject;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class JunitResultPublisher
extends TestDataPublisher {
    private static final String MESSAGE_PATH = "path";
    private static final String MESSAGE_CLIP_NAME = "clipName";
    private static final String MESSAGE_CLIP_TYPE = "type";
    private String urlOverride;

    @DataBoundConstructor
    public JunitResultPublisher(String urlOverride) {
        this.urlOverride = urlOverride;
    }

    public String getUrlOverride() {
        return this.urlOverride;
    }

    public TestResultAction.Data getTestData(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, TestResult testResult) throws IOException {
        Data data = new Data();
        for (SuiteResult sr : testResult.getSuites()) {
            JunitResultAction action = new JunitResultAction();
            String fileName = sr.getFile();
            String workspacePath = build.getWorkspace().getRemote();
            if (fileName == null || fileName.isEmpty()) {
                listener.error("The selected JUnit XML file " + sr.getName() + " has no content in it.  Skipping.");
                continue;
            }
            if (fileName.startsWith(workspacePath)) {
                try {
                    String relativePath = fileName.substring(workspacePath.length() + 1);
                    String fileContent = build.getWorkspace().child(relativePath).readToString();
                    Document junitXML = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(fileContent)));
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    String resultID = (String)xPath.evaluate("//testcase[1]/@resultID", junitXML, XPathConstants.STRING);
                    if (resultID != null && resultID.trim().length() > 0) {
                        String url = this.urlOverride != null && this.urlOverride.trim().length() > 0 ? this.urlOverride : (String)xPath.evaluate("//testsuite/@url", junitXML, XPathConstants.STRING);
                        NodeList messageNodes = (NodeList)xPath.evaluate("//testcase[1]/messages/message", junitXML, XPathConstants.NODESET);
                        ArrayList<Message> messages = new ArrayList<Message>();
                        if (messageNodes != null) {
                            Message resultsMessage = null;
                            for (int i = 0; i < messageNodes.getLength(); ++i) {
                                Node messageNode = messageNodes.item(i);
                                String type = this.getNodeTextContent(messageNode, MESSAGE_CLIP_TYPE);
                                String path = this.getNodeTextContent(messageNode, MESSAGE_PATH);
                                if (path == null) {
                                    path = this.getNodeTextContent(messageNode, MESSAGE_CLIP_NAME);
                                }
                                String message = messageNode.getTextContent();
                                resultsMessage = new Message(type, path, message);
                                messages.add(resultsMessage);
                            }
                        }
                        if (resultID.equals("NA")) {
                            action.setPlayList(true);
                        }
                        action.setResultID(resultID);
                        action.setUrl(url);
                        action.setMessages(messages);
                    }
                    data.addTestAction(((CaseResult)sr.getCases().get(0)).getId(), action);
                }
                catch (Exception e) {
                    listener.error("File \"" + fileName + "\" could not be processed (" + e.getMessage() + ").  Skipping.");
                }
                continue;
            }
            listener.error("File \"" + fileName + "\" does not appear to be in build workspace.  Skipping.");
        }
        return data;
    }

    private String getNodeTextContent(Node node, String namedItem) {
        if (node == null || !node.hasAttributes()) {
            return null;
        }
        Node nodeValue = node.getAttributes().getNamedItem(namedItem);
        if (nodeValue == null) {
            return null;
        }
        return nodeValue.getTextContent();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<TestDataPublisher> {
        public String getDisplayName() {
            return "Include links to SOASTA CloudTest dashboards";
        }

        public FormValidation doCheckUrlOverride(@QueryParameter String value) {
            if (value == null || value.trim().length() == 0) {
                return FormValidation.ok();
            }
            try {
                new URL(value);
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)"Invalid URL");
            }
        }
    }

    private static class Data
    extends TestResultAction.Data {
        private Map<String, JunitResultAction> actions = new HashMap<String, JunitResultAction>();

        private Data() {
        }

        public List<TestAction> getTestAction(TestObject testObject) {
            String id;
            JunitResultAction action;
            if (testObject instanceof CaseResult && (action = this.actions.get(id = testObject.getId())) != null) {
                return Collections.singletonList(action);
            }
            return Collections.emptyList();
        }

        public void addTestAction(String testObjectId, JunitResultAction action) {
            this.actions.put(testObjectId, action);
        }
    }
}

