/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins;

import com.soasta.jenkins.CloudTestServer;
import com.soasta.jenkins.Installers;
import com.soasta.jenkins.httpclient.GenericSelfClosingHttpClient;
import com.soasta.jenkins.httpclient.HttpClientSettings;
import hudson.FilePath;
import hudson.Functions;
import hudson.ProxyConfiguration;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tools.DownloadFromUrlInstaller;
import hudson.tools.ToolInstallation;
import hudson.util.IOUtils;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import jenkins.model.Jenkins;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.jenkinsci.remoting.RoleChecker;

public class CommonInstaller
extends DownloadFromUrlInstaller {
    private final CloudTestServer server;
    private final VersionNumber buildNumber;
    private final Installers installerType;
    private static final Logger LOGGER = Logger.getLogger(CommonInstaller.class.getName());

    private CommonInstaller(CloudTestServer server, Installers installerType, VersionNumber buildNumber) {
        super(installerType.getCTInstallerType() + buildNumber);
        this.server = server;
        this.installerType = installerType;
        this.buildNumber = buildNumber;
    }

    CommonInstaller(CloudTestServer server, Installers installFileType) throws IOException {
        this(server, installFileType, server.getBuildNumber());
    }

    CloudTestServer getServer() {
        return this.server;
    }

    VersionNumber getBuildNumber() {
        return this.buildNumber;
    }

    Installers getInstallerType() {
        return this.installerType;
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        try {
            return super.performInstallation(tool, node, log);
        }
        catch (IOException e) {
            FilePath expected = this.preferredLocation(tool, node);
            DownloadFromUrlInstaller.Installable inst = this.getInstallable();
            if (this.installIfNecessaryFrom(expected, new URL(inst.url), log, "Unpacking " + inst.url + " to " + expected + " on " + node.getDisplayName())) {
                expected.child(".timestamp").delete();
                FilePath base = this.findPullUpDirectory(expected);
                if (base != null && base != expected) {
                    base.moveAllChildrenTo(expected);
                }
                expected.child(".installedFrom").write(inst.url, "UTF-8");
                expected.act((FilePath.FileCallable)new ChmodRecAPlusX());
            }
            return expected;
        }
    }

    private boolean installIfNecessaryFrom(FilePath expected, URL archive, TaskListener listener, String message) throws IOException, InterruptedException {
        try {
            long sourceTimestamp;
            FilePath timestamp;
            block19: {
                URLConnection con;
                timestamp = expected.child(".timestamp");
                try {
                    con = ProxyConfiguration.open((URL)archive);
                    con.setRequestProperty("User-Agent", "Jenkins/" + Jenkins.getVersion().toString());
                    if (con instanceof HttpsURLConnection) {
                        HttpsURLConnection https = (HttpsURLConnection)con;
                        CloudTestServer server = this.getServer();
                        String password = server.getKeyStorePassword().getPlainText() == null || server.getKeyStorePassword().getPlainText().isEmpty() ? null : server.getKeyStorePassword().getPlainText();
                        HttpClientSettings settings = new HttpClientSettings().setKeyStore(HttpClientSettings.loadKeyStore(server.getKeyStoreLocation(), password)).setKeyStorePassword(server.getKeyStorePassword().getPlainText()).setTrustSelfSigned(server.isTrustSelfSigned());
                        KeyManager[] keyManagers = GenericSelfClosingHttpClient.getKeyManagers(settings);
                        TrustManager[] trustManagers = null;
                        if (server.isTrustSelfSigned()) {
                            trustManagers = GenericSelfClosingHttpClient.getTrustAllSelfSigned();
                        }
                        SSLContext sslContext = null;
                        try {
                            sslContext = SSLContext.getInstance("TLS");
                            sslContext.init(keyManagers, trustManagers, new SecureRandom());
                            https.setSSLSocketFactory(sslContext.getSocketFactory());
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, "Error setting ssl context", e);
                        }
                    }
                    LOGGER.log(Level.INFO, "Setting User-Agent for download to " + con.getRequestProperty("User-Agent") + " for file " + archive.getPath());
                    if (timestamp.exists()) {
                        con.setIfModifiedSince(timestamp.lastModified());
                    }
                    con.connect();
                }
                catch (IOException x) {
                    if (expected.exists()) {
                        if (listener != null) {
                            LOGGER.log(Level.INFO, "Skipping installation of " + archive + " to " + expected.getRemote() + ": " + x);
                        }
                        return false;
                    }
                    throw x;
                }
                LOGGER.log(Level.INFO, "Connection response code is: " + ((HttpURLConnection)con).getResponseCode());
                if (con instanceof HttpURLConnection && ((HttpURLConnection)con).getResponseCode() == 304) {
                    return false;
                }
                sourceTimestamp = con.getLastModified();
                if (expected.exists()) {
                    LOGGER.log(Level.INFO, "Not creating a new " + expected.getRemote() + " as one already exists.");
                    if (timestamp.exists() && sourceTimestamp == timestamp.lastModified()) {
                        return false;
                    }
                    expected.deleteContents();
                } else {
                    expected.mkdirs();
                }
                if (listener != null) {
                    LOGGER.log(Level.INFO, message);
                }
                if (expected.isRemote()) {
                    LOGGER.log(Level.INFO, "Treating this as a remote request.");
                    try {
                        expected.act((FilePath.FileCallable)new Unpack(archive));
                        timestamp.touch(sourceTimestamp);
                        return true;
                    }
                    catch (IOException x) {
                        if (listener == null) break block19;
                        listener.error("Failed to download " + archive + " because of " + x.getLocalizedMessage() + "; will retry.");
                    }
                }
            }
            expected.act((FilePath.FileCallable)new Unpack(archive));
            timestamp.touch(sourceTimestamp);
            return true;
        }
        catch (IOException e) {
            throw new IOException("Failed to install " + archive + " to " + expected.getRemote(), e);
        }
    }

    private static final class Unpack
    implements FilePath.FileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final URL archive;

        Unpack(URL archive) {
            this.archive = archive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
            URLConnection con = this.archive.openConnection();
            con.setRequestProperty("User-Agent", "Jenkins/" + Jenkins.getVersion().toString());
            InputStream in = con.getInputStream();
            try {
                CountingInputStream cis = new CountingInputStream(in);
                try {
                    LOGGER.log(Level.INFO, "Invoke called for Unpack class to unpack to " + dir.getAbsolutePath());
                    if (this.archive.toExternalForm().endsWith(".zip")) {
                        LOGGER.log(Level.INFO, "Archive unzipped as it ends with '.zip'.  Starting unzip.");
                        Unpack.unzip(dir, (InputStream)cis);
                    }
                }
                catch (IOException x) {
                    throw new IOException(String.format("Failed to unpack %s (%d bytes read)", this.archive, cis.getByteCount()), x);
                }
            }
            finally {
                in.close();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void unzip(File dir, InputStream in) throws IOException {
            File tmpFile = File.createTempFile("tmpzip", null);
            try {
                IOUtils.copy((InputStream)in, (File)tmpFile);
                Unpack.unzip(dir, tmpFile);
            }
            finally {
                tmpFile.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void unzip(File dir, File zipFile) throws IOException {
            dir = dir.getAbsoluteFile();
            ZipFile zip = new ZipFile(zipFile);
            Enumeration entries = zip.getEntries();
            try {
                while (entries.hasMoreElements()) {
                    ZipEntry e = (ZipEntry)entries.nextElement();
                    File f = new File(dir, e.getName());
                    if (e.isDirectory()) {
                        f.mkdirs();
                        continue;
                    }
                    File p = f.getParentFile();
                    if (p != null) {
                        p.mkdirs();
                    }
                    InputStream input = zip.getInputStream(e);
                    try {
                        IOUtils.copy((InputStream)input, (File)f);
                    }
                    finally {
                        input.close();
                    }
                    try {
                        FilePath target = new FilePath(f);
                        int mode = e.getUnixMode();
                        if (mode != 0) {
                            target.chmod(mode);
                        }
                    }
                    catch (InterruptedException ex) {
                        LOGGER.log(Level.WARNING, "unable to set permissions", ex);
                    }
                    f.setLastModified(e.getTime());
                }
            }
            finally {
                zip.close();
            }
        }

        public void checkRoles(RoleChecker arg0) throws SecurityException {
        }
    }

    static class ChmodRecAPlusX
    implements FilePath.FileCallable<Void> {
        private static final long serialVersionUID = 1L;

        ChmodRecAPlusX() {
        }

        public Void invoke(File d, VirtualChannel channel) throws IOException {
            if (!Functions.isWindows()) {
                this.process(d);
            }
            return null;
        }

        private void process(File f) {
            if (f.isFile()) {
                f.setExecutable(true, false);
            } else {
                File[] kids = f.listFiles();
                if (kids != null) {
                    for (File kid : kids) {
                        this.process(kid);
                    }
                }
            }
        }

        public void checkRoles(RoleChecker arg0) throws SecurityException {
        }
    }
}

