/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins;

import com.soasta.jenkins.httpclient.GenericSelfClosingHttpClient;
import com.soasta.jenkins.httpclient.HttpClientSettings;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import hudson.util.VersionNumber;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class CloudTestServer
extends AbstractDescribableImpl<CloudTestServer> {
    private final String url;
    private final String apitoken;
    private final String username;
    private final Secret password;
    private final String id;
    private final String name;
    private final String keyStoreLocation;
    private final Secret keyStorePassword;
    private final boolean trustSelfSigned;
    private static final String REPOSITORY_SERVICE_BASE_URL = "/services/rest/RepositoryService/v1/Tokens";
    private transient boolean generatedIdOrName;
    private static final Logger LOGGER = Logger.getLogger(CloudTestServer.class.getName());

    @DataBoundConstructor
    public CloudTestServer(String url, String username, Secret password, String id, String name, String apitoken, String keyStoreLocation, Secret keyStorePassword, boolean trustSelfSigned) throws MalformedURLException {
        this.keyStoreLocation = keyStoreLocation;
        this.keyStorePassword = keyStorePassword;
        this.trustSelfSigned = trustSelfSigned;
        if (url == null || url.isEmpty()) {
            this.url = null;
        } else {
            if (!url.endsWith("/")) {
                url = url + '/';
            }
            if (!url.endsWith("/concerto/")) {
                url = url + "concerto/";
            }
            this.url = url;
        }
        this.username = username == null || username.isEmpty() ? "" : username;
        this.password = password == null || password.getPlainText() == null || password.getPlainText().isEmpty() ? null : password;
        this.apitoken = apitoken == null || apitoken.isEmpty() ? "" : apitoken;
        if (id == null || id.isEmpty()) {
            this.id = UUID.randomUUID().toString();
            this.generatedIdOrName = true;
        } else {
            this.id = id;
        }
        if (name == null || name.isEmpty()) {
            if (this.url == null) {
                this.name = "";
            } else {
                this.name = url + " (" + username + ")";
                this.generatedIdOrName = true;
            }
        } else {
            this.name = name;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getId() {
        return this.id;
    }

    public String getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public Secret getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public boolean isTrustSelfSigned() {
        return this.trustSelfSigned;
    }

    public String getName() {
        return this.name;
    }

    public String getApitoken() {
        return this.apitoken;
    }

    public Object readResolve() throws IOException {
        if (this.id != null && this.id.trim().length() > 0 && this.name != null && this.name.trim().length() > 0) {
            return this;
        }
        LOGGER.info("Re-creating object to generate a new server ID and name.");
        return new CloudTestServer(this.url, this.username, this.password, this.id, this.name, this.apitoken, this.keyStoreLocation, this.keyStorePassword, this.trustSelfSigned);
    }

    public FormValidation validate() throws IOException {
        try {
            GenericSelfClosingHttpClient client = this.createClient();
            JSONObject obj = new JSONObject();
            if (this.apitoken.trim().isEmpty() && !this.username.trim().isEmpty() && this.password != null) {
                obj.put("userName", (Object)this.username);
                obj.put("password", (Object)this.password.getPlainText());
            } else if (!this.apitoken.trim().isEmpty() && this.username.trim().isEmpty() && this.password == null) {
                if (this.apitoken.length() != 36) {
                    throw new IOException("Invalid API Token");
                }
                obj.put("apiToken", (Object)this.apitoken);
            }
            HttpPut put = new HttpPut(this.url + REPOSITORY_SERVICE_BASE_URL);
            StringEntity jsonEntity = new StringEntity(obj.toString(), "UTF-8");
            jsonEntity.setContentType("application/json");
            put.setEntity((HttpEntity)jsonEntity);
            client.sendRequest((HttpUriRequest)put);
            return FormValidation.ok((String)"Success!");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to valdiate", e);
            return FormValidation.error((String)e.getMessage());
        }
    }

    public VersionNumber getBuildNumber() throws IOException {
        String buildNumber;
        HttpGet get;
        if (this.url == null) {
            throw new IllegalStateException("No URL has been configured for this CloudTest server.");
        }
        GenericSelfClosingHttpClient client = this.createClient();
        String responseBody = client.sendRequest((HttpUriRequest)(get = new HttpGet(this.url)));
        Document doc = Jsoup.parse((String)responseBody);
        Elements elements = doc.select("meta[name=buildnumber]");
        if (elements != null && elements.size() >= 1 && (buildNumber = ((Element)elements.get(0)).attr("content")) != null) {
            return new VersionNumber(buildNumber);
        }
        throw new Error("failed to find build number");
    }

    private GenericSelfClosingHttpClient createClient() throws IOException {
        return new GenericSelfClosingHttpClient(new HttpClientSettings().setKeyStore(HttpClientSettings.loadKeyStore(this.keyStoreLocation, Secret.toString((Secret)this.keyStorePassword))).setKeyStorePassword(this.keyStorePassword == null || this.keyStorePassword.getPlainText().isEmpty() ? null : this.keyStorePassword.getPlainText()).setUrl(this.url).setTrustSelfSigned(this.trustSelfSigned));
    }

    public static CloudTestServer getByURL(String url) {
        List<CloudTestServer> servers = ((DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class)).getServers();
        for (CloudTestServer s : servers) {
            if (!s.getUrl().equals(url)) continue;
            return s;
        }
        if (!servers.isEmpty()) {
            return servers.get(0);
        }
        return null;
    }

    public static CloudTestServer getByID(String id) {
        List<CloudTestServer> servers = ((DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class)).getServers();
        for (CloudTestServer s : servers) {
            if (!s.getId().equals(id)) continue;
            return s;
        }
        if (!servers.isEmpty()) {
            return servers.get(0);
        }
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<CloudTestServer> {
        private volatile List<CloudTestServer> servers;
        boolean setUsername;
        boolean setApiToken;

        public DescriptorImpl() {
            this.load();
            if (this.servers == null) {
                this.servers = new ArrayList<CloudTestServer>();
            } else {
                for (CloudTestServer s : this.servers) {
                    if (!s.generatedIdOrName) continue;
                    LOGGER.info("Persisting generated server IDs and/or names.");
                    this.save();
                    break;
                }
            }
        }

        public String getDisplayName() {
            return "CloudTest Server";
        }

        public List<CloudTestServer> getServers() {
            return this.servers;
        }

        public void setServers(Collection<? extends CloudTestServer> servers) {
            this.servers = new ArrayList<CloudTestServer>(servers);
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.setServers(req.bindJSONToList(CloudTestServer.class, json.get("servers")));
            this.save();
            return true;
        }

        public FormValidation doValidate(@QueryParameter String url, @QueryParameter String username, @QueryParameter String password, @QueryParameter String id, @QueryParameter String name, @QueryParameter String apitoken, @QueryParameter String keyStoreLocation, @QueryParameter String keyStorePassword, @QueryParameter boolean trustSelfSigned) throws IOException {
            return new CloudTestServer(url, username, Secret.fromString((String)password), id, name, apitoken, keyStoreLocation, Secret.fromString((String)keyStorePassword), trustSelfSigned).validate();
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Required.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUrl(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Required.");
            }
            if (!DescriptorImpl.isValidURL(value)) {
                return FormValidation.error((String)("Invalid URL syntax (did you mean http://" + value + " ?"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUsername(@QueryParameter String value) {
            if (this.setApiToken && (value == null || value.trim().isEmpty())) {
                this.setUsername = false;
                return FormValidation.ok();
            }
            if (!this.setApiToken && (value == null || value.trim().isEmpty())) {
                this.setUsername = false;
                return FormValidation.error((String)"Username/Password or API Token Required.");
            }
            if (!(this.setApiToken || value == null && value.trim().isEmpty())) {
                this.setUsername = true;
                return FormValidation.ok();
            }
            this.setUsername = true;
            return FormValidation.error((String)"Cannot use both Username/Password and API Token");
        }

        public FormValidation doCheckPassword(@QueryParameter String value) {
            if (this.setApiToken && !this.setUsername && (value == null || value.trim().isEmpty())) {
                return FormValidation.ok();
            }
            if (!this.setApiToken && this.setUsername && (value == null || value.trim().isEmpty())) {
                return FormValidation.error((String)"Password Required.");
            }
            if (!(this.setApiToken || !this.setUsername || value == null && value.trim().isEmpty())) {
                return FormValidation.ok();
            }
            if (!this.setApiToken && !this.setUsername) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Cannot use both Username/Password and API Token");
        }

        public FormValidation doCheckApitoken(@QueryParameter String value) {
            if (this.setUsername && (value == null || value.trim().isEmpty())) {
                this.setApiToken = false;
                return FormValidation.ok();
            }
            if (!this.setUsername && (value == null || value.trim().isEmpty())) {
                this.setApiToken = false;
                return FormValidation.error((String)"Username/Password or API Token Required.");
            }
            if (!(this.setUsername || value == null && value.trim().isEmpty())) {
                if (value.length() != 32) {
                    return FormValidation.error((String)"Invalid API Token");
                }
                this.setApiToken = true;
                return FormValidation.ok();
            }
            this.setApiToken = true;
            return FormValidation.error((String)"Cannot use both Username/Password and API Token");
        }

        private static boolean isValidURL(String url) {
            try {
                new URL(url);
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
    }
}

