/*
 * Decompiled with CFR 0.152.
 */
package com.snatik.storage;

import android.os.Build;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class SimpleStorageConfiguration {
    private int mChunkSize;
    private boolean mIsEncrypted;
    private byte[] mIvParameter;
    private byte[] mSecretKey;

    private SimpleStorageConfiguration(Builder builder) {
        this.mChunkSize = builder._chunkSize;
        this.mIsEncrypted = builder._isEncrypted;
        this.mIvParameter = builder._ivParameter;
        this.mSecretKey = builder._secretKey;
    }

    public int getChuckSize() {
        return this.mChunkSize;
    }

    public boolean isEncrypted() {
        return this.mIsEncrypted;
    }

    public byte[] getSecretKey() {
        return this.mSecretKey;
    }

    public byte[] getIvParameter() {
        return this.mIvParameter;
    }

    public static class Builder {
        private int _chunkSize = 8192;
        private boolean _isEncrypted = false;
        private byte[] _ivParameter = null;
        private byte[] _secretKey = null;
        private static final String UTF_8 = "UTF-8";

        public SimpleStorageConfiguration build() {
            return new SimpleStorageConfiguration(this);
        }

        public Builder setChuckSize(int chunkSize) {
            this._chunkSize = chunkSize;
            return this;
        }

        public Builder setEncryptContent(String ivx, String secretKey) {
            this._isEncrypted = true;
            try {
                this._ivParameter = ivx.getBytes(UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)"SimpleStorageConfiguration", (String)"UnsupportedEncodingException", (Throwable)e);
            }
            try {
                int iterationCount = 1000;
                int keyLength = 128;
                SecureRandom random = new SecureRandom();
                byte[] salt = new byte[16];
                random.nextBytes(salt);
                PBEKeySpec keySpec = new PBEKeySpec(secretKey.toCharArray(), salt, iterationCount, keyLength);
                SecretKeyFactory keyFactory = null;
                keyFactory = Build.VERSION.SDK_INT >= 19 ? SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1And8bit") : SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
                byte[] keyBytes = keyFactory.generateSecret(keySpec).getEncoded();
                this._secretKey = keyBytes;
            }
            catch (InvalidKeySpecException e) {
                Log.e((String)"SimpleStorageConfiguration", (String)"InvalidKeySpecException", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                Log.e((String)"SimpleStorageConfiguration", (String)"NoSuchAlgorithmException", (Throwable)e);
            }
            return this;
        }
    }
}

