/*
 * Decompiled with CFR 0.152.
 */
package com.snatik.storage;

import android.content.Context;
import android.os.Environment;
import com.snatik.storage.AbstractDiskStorage;
import com.snatik.storage.SimpleStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class InternalStorage
extends AbstractDiskStorage {
    private Context mContext;

    InternalStorage() {
    }

    void initActivity(Context context) {
        this.mContext = context;
    }

    @Override
    public SimpleStorage.StorageType getStorageType() {
        return SimpleStorage.StorageType.INTERNAL;
    }

    @Override
    public boolean createDirectory(String name) {
        File dir = this.mContext.getDir(name, 0);
        return dir.exists();
    }

    public boolean createFile(String name, String content) {
        try {
            byte[] bytes = content.getBytes();
            if (this.getConfiguration().isEncrypted()) {
                bytes = this.encrypt(bytes, 1);
            }
            FileOutputStream fos = this.mContext.openFileOutput(name, 0);
            fos.write(bytes);
            fos.close();
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create private file on internal storage", e);
        }
    }

    public byte[] readFile(String name) {
        try {
            FileInputStream stream = this.mContext.openFileInput(name);
            byte[] out = this.readFile(stream);
            return out;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create private file on internal storage", e);
        }
    }

    @Override
    protected String buildAbsolutePath() {
        return Environment.getRootDirectory().getAbsolutePath();
    }

    @Override
    protected String buildPath(String directoryName) {
        String path = this.mContext.getDir(directoryName, 0).getAbsolutePath();
        return path;
    }

    @Override
    protected String buildPath(String directoryName, String fileName) {
        String path = this.mContext.getDir(directoryName, 0).getAbsolutePath();
        path = path + File.separator + fileName;
        return path;
    }
}

