/*
 * Decompiled with CFR 0.152.
 */
package com.snatik.storage;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.StatFs;
import android.util.Log;
import com.snatik.storage.SimpleStorage;
import com.snatik.storage.SimpleStorageConfiguration;
import com.snatik.storage.Storable;
import com.snatik.storage.Storage;
import com.snatik.storage.helpers.ImmutablePair;
import com.snatik.storage.helpers.OrderType;
import com.snatik.storage.helpers.SizeUnit;
import com.snatik.storage.security.SecurityUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

abstract class AbstractDiskStorage
implements Storage {
    protected static final String UTF_8 = "UTF-8";
    private static final String TAG = "AbstractDiskStorage";

    AbstractDiskStorage() {
    }

    protected SimpleStorageConfiguration getConfiguration() {
        return SimpleStorage.getConfiguration();
    }

    @Override
    public boolean createDirectory(String name) {
        String path = this.buildPath(name);
        File directory = new File(path);
        if (directory.exists()) {
            Log.w((String)TAG, (String)("Directory '" + name + "' already exists"));
            return false;
        }
        return directory.mkdirs();
    }

    @Override
    public boolean createDirectory(String name, boolean override) {
        if (override && this.isDirectoryExists(name)) {
            this.deleteDirectory(name);
        }
        return this.createDirectory(name);
    }

    @Override
    public boolean deleteDirectory(String name) {
        String path = this.buildPath(name);
        return this.deleteDirectoryImpl(path);
    }

    @Override
    public boolean isDirectoryExists(String name) {
        String path = this.buildPath(name);
        return new File(path).exists();
    }

    @Override
    public boolean createFile(String directoryName, String fileName, String content) {
        return this.createFile(directoryName, fileName, content.getBytes());
    }

    @Override
    public boolean createFile(String directoryName, String fileName, Storable storable) {
        return this.createFile(directoryName, fileName, storable.getBytes());
    }

    @Override
    public boolean createFile(String directoryName, String fileName, byte[] content) {
        String path = this.buildPath(directoryName, fileName);
        try {
            FileOutputStream stream = new FileOutputStream(new File(path));
            if (this.getConfiguration().isEncrypted()) {
                content = this.encrypt(content, 1);
            }
            ((OutputStream)stream).write(content);
            stream.flush();
            ((OutputStream)stream).close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Failed create file", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean createFile(String directoryName, String fileName, Bitmap bitmap) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        byte[] byteArray = stream.toByteArray();
        return this.createFile(directoryName, fileName, byteArray);
    }

    @Override
    public boolean deleteFile(String directoryName, String fileName) {
        String path = this.buildPath(directoryName, fileName);
        File file = new File(path);
        return file.delete();
    }

    @Override
    public boolean isFileExist(String directoryName, String fileName) {
        String path = this.buildPath(directoryName, fileName);
        return new File(path).exists();
    }

    @Override
    public byte[] readFile(String directoryName, String fileName) {
        String path = this.buildPath(directoryName, fileName);
        try {
            FileInputStream stream = new FileInputStream(new File(path));
            return this.readFile(stream);
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"Failed to read file to input stream", (Throwable)e);
            return null;
        }
    }

    @Override
    public String readTextFile(String directoryName, String fileName) {
        byte[] bytes = this.readFile(directoryName, fileName);
        return new String(bytes);
    }

    @Override
    public void appendFile(String directoryName, String fileName, String content) {
        this.appendFile(directoryName, fileName, content.getBytes());
    }

    @Override
    public void appendFile(String directoryName, String fileName, byte[] bytes) {
        if (!this.isFileExist(directoryName, fileName)) {
            Log.w((String)TAG, (String)"Impossible to append content, because such file doesn't exist");
            return;
        }
        try {
            String path = this.buildPath(directoryName, fileName);
            FileOutputStream stream = new FileOutputStream(new File(path), true);
            stream.write(bytes);
            stream.write(System.getProperty("line.separator").getBytes());
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Failed to append content to file", (Throwable)e);
        }
    }

    @Override
    public List<File> getNestedFiles(String directoryName) {
        String buildPath = this.buildPath(directoryName);
        File file = new File(buildPath);
        ArrayList<File> out = new ArrayList<File>();
        this.getDirectoryFilesImpl(file, out);
        return out;
    }

    @Override
    public List<File> getFiles(String directoryName, final String matchRegex) {
        List<File> out;
        String buildPath = this.buildPath(directoryName);
        File file = new File(buildPath);
        if (matchRegex != null) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String fileName) {
                    return fileName.matches(matchRegex);
                }
            };
            out = Arrays.asList(file.listFiles(filter));
        } else {
            out = Arrays.asList(file.listFiles());
        }
        return out;
    }

    @Override
    public List<File> getFiles(String directoryName, OrderType orderType) {
        List<File> files = this.getFiles(directoryName, (String)null);
        Collections.sort(files, orderType.getComparator());
        return files;
    }

    @Override
    public File getFile(String name) {
        String path = this.buildPath(name);
        File file = new File(path);
        return file;
    }

    @Override
    public File getFile(String directoryName, String fileName) {
        String path = this.buildPath(directoryName, fileName);
        return new File(path);
    }

    @Override
    public void rename(File file, String newName) {
        String name = file.getName();
        String newFullName = file.getAbsolutePath().replaceAll(name, newName);
        File newFile = new File(newFullName);
        file.renameTo(newFile);
    }

    @Override
    public double getSize(File file, SizeUnit unit) {
        long length = file.length();
        return (double)length / (double)unit.inBytes();
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public long getFreeSpace(SizeUnit sizeUnit) {
        long blockSize;
        long availableBlocks;
        String path = this.buildAbsolutePath();
        StatFs statFs = new StatFs(path);
        if (Build.VERSION.SDK_INT < 18) {
            availableBlocks = statFs.getAvailableBlocks();
            blockSize = statFs.getBlockSize();
        } else {
            availableBlocks = statFs.getAvailableBlocksLong();
            blockSize = statFs.getBlockSizeLong();
        }
        long freeBytes = availableBlocks * blockSize;
        return freeBytes / sizeUnit.inBytes();
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public long getUsedSpace(SizeUnit sizeUnit) {
        long totalBlocks;
        long blockSize;
        long availableBlocks;
        String path = this.buildAbsolutePath();
        StatFs statFs = new StatFs(path);
        if (Build.VERSION.SDK_INT < 18) {
            availableBlocks = statFs.getAvailableBlocks();
            blockSize = statFs.getBlockSize();
            totalBlocks = statFs.getBlockCount();
        } else {
            availableBlocks = statFs.getAvailableBlocksLong();
            blockSize = statFs.getBlockSizeLong();
            totalBlocks = statFs.getBlockCountLong();
        }
        long usedBytes = totalBlocks * blockSize - availableBlocks * blockSize;
        return usedBytes / sizeUnit.inBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(File file, String directoryName, String fileName) {
        if (!file.isFile()) {
            return;
        }
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = new FileInputStream(file);
            outStream = new FileOutputStream(new File(this.buildPath(directoryName, fileName)));
            FileChannel inChannel = inStream.getChannel();
            FileChannel outChannel = outStream.getChannel();
            inChannel.transferTo(0L, inChannel.size(), outChannel);
            this.closeQuietly(inStream);
            this.closeQuietly(outStream);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed copy", (Throwable)e);
        }
        finally {
            this.closeQuietly(inStream);
            this.closeQuietly(outStream);
        }
    }

    @Override
    public void move(File file, String directoryName, String fileName) {
        this.copy(file, directoryName, fileName);
        file.delete();
    }

    protected byte[] readFile(final FileInputStream stream) {
        class Reader
        extends Thread {
            byte[] array = null;

            Reader() {
            }
        }
        Reader reader = new Reader(){
            {
            }

            @Override
            public void run() {
                LinkedList<ImmutablePair<byte[], Integer>> chunks = new LinkedList<ImmutablePair<byte[], Integer>>();
                int size = 0;
                int globalSize = 0;
                do {
                    try {
                        int chunkSize = AbstractDiskStorage.this.getConfiguration().getChuckSize();
                        byte[] buffer = new byte[chunkSize];
                        size = stream.read(buffer, 0, chunkSize);
                        if (size <= 0) continue;
                        globalSize += size;
                        chunks.add(new ImmutablePair<byte[], Integer>(buffer, size));
                    }
                    catch (Exception chunkSize) {
                        // empty catch block
                    }
                } while (size > 0);
                try {
                    stream.close();
                }
                catch (Exception chunkSize) {
                    // empty catch block
                }
                this.array = new byte[globalSize];
                int offset = 0;
                for (ImmutablePair immutablePair : chunks) {
                    System.arraycopy(immutablePair.element1, 0, this.array, offset, (Integer)immutablePair.element2);
                    offset += ((Integer)immutablePair.element2).intValue();
                }
            }
        };
        reader.start();
        try {
            reader.join();
        }
        catch (InterruptedException e) {
            Log.e((String)TAG, (String)"Failed on reading file from storage while the locking Thread", (Throwable)e);
            return null;
        }
        if (this.getConfiguration().isEncrypted()) {
            return this.encrypt(reader.array, 2);
        }
        return reader.array;
    }

    protected abstract String buildAbsolutePath();

    protected abstract String buildPath(String var1);

    protected abstract String buildPath(String var1, String var2);

    protected synchronized byte[] encrypt(byte[] content, int encryptionMode) {
        byte[] secretKey = this.getConfiguration().getSecretKey();
        byte[] ivx = this.getConfiguration().getIvParameter();
        return SecurityUtil.encrypt(content, encryptionMode, secretKey, ivx);
    }

    private boolean deleteDirectoryImpl(String path) {
        File directory = new File(path);
        if (directory.exists()) {
            File[] files = directory.listFiles();
            if (files == null) {
                return true;
            }
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectoryImpl(files[i].getAbsolutePath());
                    continue;
                }
                files[i].delete();
            }
        }
        return directory.delete();
    }

    private void getDirectoryFilesImpl(File directory, List<File> out) {
        if (directory.exists()) {
            File[] files = directory.listFiles();
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.getDirectoryFilesImpl(files[i], out);
                    continue;
                }
                out.add(files[i]);
            }
        }
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

