/*
 * Decompiled with CFR 0.152.
 */
package com.snappydb.internal;

import android.util.Log;
import com.snappydb.KeyIterator;
import com.snappydb.SnappydbException;
import com.snappydb.internal.DBImpl;
import java.util.Iterator;
import java.util.NoSuchElementException;

class KeyIteratorImpl
implements KeyIterator {
    private final DBImpl db;
    private final String endPrefix;
    private final boolean reverse;
    private long ptr;
    private boolean isNextValid;

    protected KeyIteratorImpl(DBImpl db, long ptr, String endPrefix, boolean reverse) {
        this.db = db;
        this.ptr = ptr;
        this.endPrefix = endPrefix;
        this.reverse = reverse;
        this.isNextValid = db.__iteratorIsValid(ptr, endPrefix, reverse);
    }

    @Override
    public void close() {
        if (this.ptr != 0L) {
            this.db.__iteratorClose(this.ptr);
        }
        this.ptr = 0L;
        this.isNextValid = false;
    }

    protected void finalize() throws Throwable {
        if (this.ptr != 0L) {
            Log.w((String)"KeyIterator", (String)"SnappyDB iterators must be closed");
            this.close();
        }
        super.finalize();
    }

    @Override
    public boolean hasNext() {
        return this.isNextValid;
    }

    @Override
    public String[] next(int max) {
        if (!this.isNextValid) {
            throw new NoSuchElementException();
        }
        try {
            String[] keys = this.db.__iteratorNextArray(this.ptr, this.endPrefix, this.reverse, max);
            this.isNextValid = this.db.__iteratorIsValid(this.ptr, this.endPrefix, this.reverse);
            if (!this.isNextValid) {
                this.close();
            }
            return keys;
        }
        catch (SnappydbException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterable<String[]> byBatch(int size) {
        return new BatchIterableImpl(size);
    }

    private class BatchIterableImpl
    implements Iterable<String[]>,
    Iterator<String[]> {
        private int size;

        private BatchIterableImpl(int size) {
            this.size = size;
        }

        @Override
        public Iterator<String[]> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return KeyIteratorImpl.this.hasNext();
        }

        @Override
        public String[] next() {
            return KeyIteratorImpl.this.next(this.size);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

