/*
 * Decompiled with CFR 0.152.
 */
package com.snappydb.internal;

import android.text.TextUtils;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.snappydb.DB;
import com.snappydb.KeyIterator;
import com.snappydb.SnappydbException;
import com.snappydb.internal.KeyIteratorImpl;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;

public class DBImpl
implements DB {
    private static final String LIB_NAME = "snappydb-native";
    private static final int LIMIT_MAX = 0x7FFFFFF7;
    private String dbPath;
    private Kryo kryo;

    public DBImpl(String path, Kryo ... kryo) throws SnappydbException {
        this.dbPath = path;
        if (null != kryo && kryo.length > 0) {
            this.kryo = kryo[0];
        } else {
            this.kryo = new Kryo();
            this.kryo.setAsmEnabled(true);
        }
        this.__open(this.dbPath);
    }

    @Override
    public void close() {
        this.__close();
    }

    @Override
    public void destroy() throws SnappydbException {
        this.__destroy(this.dbPath);
    }

    @Override
    public boolean isOpen() throws SnappydbException {
        return this.__isOpen();
    }

    @Override
    public void put(String key, String value) throws SnappydbException {
        this.checkArgs(key, value);
        this.__put(key, value);
    }

    @Override
    public void put(String key, Serializable value) throws SnappydbException {
        this.checkArgs(key, value);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.kryo.register(value.getClass());
        Output output = new Output((OutputStream)stream);
        try {
            this.kryo.writeObject(output, (Object)value);
            output.close();
            this.__put(key, stream.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SnappydbException(e.getMessage());
        }
    }

    @Override
    public void put(String key, Object value) throws SnappydbException {
        this.checkArgs(key, value);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.kryo.register(value.getClass());
        Output output = new Output((OutputStream)stream);
        try {
            this.kryo.writeObject(output, value);
            output.close();
            this.__put(key, stream.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SnappydbException(e.getMessage());
        }
    }

    @Override
    public void put(String key, byte[] value) throws SnappydbException {
        this.checkArgs(key, value);
        this.__put(key, value);
    }

    @Override
    public void put(String key, Serializable[] value) throws SnappydbException {
        this.checkArgs(key, value);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.kryo.register(value.getClass());
        Output output = new Output((OutputStream)stream);
        try {
            this.kryo.writeObject(output, (Object)value);
            output.close();
            this.__put(key, stream.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SnappydbException("Kryo exception " + e.getMessage());
        }
    }

    @Override
    public void put(String key, Object[] value) throws SnappydbException {
        this.checkArgs(key, value);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.kryo.register(value.getClass());
        Output output = new Output((OutputStream)stream);
        try {
            this.kryo.writeObject(output, (Object)value);
            output.close();
            this.__put(key, stream.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SnappydbException("Kryo exception " + e.getMessage());
        }
    }

    @Override
    public void putShort(String key, short val) throws SnappydbException {
        this.checkKey(key);
        this.__putShort(key, val);
    }

    @Override
    public void putInt(String key, int val) throws SnappydbException {
        this.checkKey(key);
        this.__putInt(key, val);
    }

    @Override
    public void putBoolean(String key, boolean val) throws SnappydbException {
        this.checkKey(key);
        this.__putBoolean(key, val);
    }

    @Override
    public void putDouble(String key, double val) throws SnappydbException {
        this.checkKey(key);
        this.__putDouble(key, val);
    }

    @Override
    public void putFloat(String key, float val) throws SnappydbException {
        this.checkKey(key);
        this.__putFloat(key, val);
    }

    @Override
    public void putLong(String key, long val) throws SnappydbException {
        this.checkKey(key);
        this.__putLong(key, val);
    }

    @Override
    public void del(String key) throws SnappydbException {
        this.checkKey(key);
        this.__del(key);
    }

    @Override
    public <T extends Serializable> T get(String key, Class<T> className) throws SnappydbException {
        this.checkArgs(key, className);
        if (className.isArray()) {
            throw new SnappydbException("You should call getArray instead");
        }
        byte[] data = this.getBytes(key);
        this.kryo.register(className);
        try (Input input = new Input(data);){
            Serializable serializable = (Serializable)this.kryo.readObject(input, className);
            return (T)serializable;
        }
    }

    @Override
    public <T> T getObject(String key, Class<T> className) throws SnappydbException {
        this.checkArgs(key, className);
        if (className.isArray()) {
            throw new SnappydbException("You should call getObjectArray instead");
        }
        byte[] data = this.getBytes(key);
        this.kryo.register(className);
        try (Input input = new Input(data);){
            Object object = this.kryo.readObject(input, className);
            return (T)object;
        }
    }

    @Override
    public <T extends Serializable> T[] getArray(String key, Class<T> className) throws SnappydbException {
        this.checkArgs(key, className);
        byte[] data = this.__getBytes(key);
        this.kryo.register(className);
        Serializable[] array = (Serializable[])Array.newInstance(className, 0);
        try (Input input = new Input(data);){
            Serializable[] serializableArray = (Serializable[])this.kryo.readObject(input, array.getClass());
            return serializableArray;
        }
    }

    @Override
    public <T> T[] getObjectArray(String key, Class<T> className) throws SnappydbException {
        this.checkArgs(key, className);
        byte[] data = this.__getBytes(key);
        this.kryo.register(className);
        Object[] array = (Object[])Array.newInstance(className, 0);
        try (Input input = new Input(data);){
            Object[] objectArray = (Object[])this.kryo.readObject(input, array.getClass());
            return objectArray;
        }
    }

    @Override
    public byte[] getBytes(String key) throws SnappydbException {
        this.checkKey(key);
        return this.__getBytes(key);
    }

    @Override
    public String get(String key) throws SnappydbException {
        this.checkKey(key);
        return this.__get(key);
    }

    @Override
    public short getShort(String key) throws SnappydbException {
        this.checkKey(key);
        return this.__getShort(key);
    }

    @Override
    public int getInt(String key) throws SnappydbException {
        this.checkKey(key);
        return this.__getInt(key);
    }

    @Override
    public boolean getBoolean(String key) throws SnappydbException {
        this.checkKey(key);
        return this.__getBoolean(key);
    }

    @Override
    public double getDouble(String key) throws SnappydbException {
        this.checkKey(key);
        return this.__getDouble(key);
    }

    @Override
    public long getLong(String key) throws SnappydbException {
        this.checkKey(key);
        return this.__getLong(key);
    }

    @Override
    public float getFloat(String key) throws SnappydbException {
        this.checkKey(key);
        return this.__getFloat(key);
    }

    @Override
    public boolean exists(String key) throws SnappydbException {
        this.checkKey(key);
        return this.__exists(key);
    }

    @Override
    public String[] findKeys(String prefix) throws SnappydbException {
        return this.findKeys(prefix, 0, 0x7FFFFFF7);
    }

    @Override
    public String[] findKeys(String prefix, int offset) throws SnappydbException {
        return this.findKeys(prefix, offset, 0x7FFFFFF7);
    }

    @Override
    public String[] findKeys(String prefix, int offset, int limit) throws SnappydbException {
        this.checkPrefix(prefix);
        this.checkOffsetLimit(offset, limit);
        return this.__findKeys(prefix, offset, limit);
    }

    @Override
    public int countKeys(String prefix) throws SnappydbException {
        this.checkPrefix(prefix);
        return this.__countKeys(prefix);
    }

    @Override
    public String[] findKeysBetween(String startPrefix, String endPrefix) throws SnappydbException {
        return this.findKeysBetween(startPrefix, endPrefix, 0, 0x7FFFFFF7);
    }

    @Override
    public String[] findKeysBetween(String startPrefix, String endPrefix, int offset) throws SnappydbException {
        return this.findKeysBetween(startPrefix, endPrefix, offset, 0x7FFFFFF7);
    }

    @Override
    public String[] findKeysBetween(String startPrefix, String endPrefix, int offset, int limit) throws SnappydbException {
        this.checkRange(startPrefix, endPrefix);
        this.checkOffsetLimit(offset, limit);
        return this.__findKeysBetween(startPrefix, endPrefix, offset, limit);
    }

    @Override
    public int countKeysBetween(String startPrefix, String endPrefix) throws SnappydbException {
        this.checkRange(startPrefix, endPrefix);
        return this.__countKeysBetween(startPrefix, endPrefix);
    }

    @Override
    public KeyIterator allKeysIterator() throws SnappydbException {
        return new KeyIteratorImpl(this, this.__findKeysIterator(null, false), null, false);
    }

    @Override
    public KeyIterator allKeysReverseIterator() throws SnappydbException {
        return new KeyIteratorImpl(this, this.__findKeysIterator(null, true), null, true);
    }

    @Override
    public KeyIterator findKeysIterator(String prefix) throws SnappydbException {
        return new KeyIteratorImpl(this, this.__findKeysIterator(prefix, false), null, false);
    }

    @Override
    public KeyIterator findKeysReverseIterator(String prefix) throws SnappydbException {
        return new KeyIteratorImpl(this, this.__findKeysIterator(prefix, true), null, true);
    }

    @Override
    public KeyIterator findKeysBetweenIterator(String startPrefix, String endPrefix) throws SnappydbException {
        return new KeyIteratorImpl(this, this.__findKeysIterator(startPrefix, false), endPrefix, false);
    }

    @Override
    public KeyIterator findKeysBetweenReverseIterator(String startPrefix, String endPrefix) throws SnappydbException {
        return new KeyIteratorImpl(this, this.__findKeysIterator(startPrefix, true), endPrefix, true);
    }

    @Override
    public Kryo getKryoInstance() {
        return this.kryo;
    }

    private void checkArgs(String key, Object value) throws SnappydbException {
        this.checkArgNotEmpty(key, "Key must not be empty");
        if (null == value) {
            throw new SnappydbException("Value must not be empty");
        }
    }

    private void checkPrefix(String prefix) throws SnappydbException {
        this.checkArgNotEmpty(prefix, "Starting prefix must not be empty");
    }

    private void checkRange(String startPrefix, String endPrefix) throws SnappydbException {
        this.checkArgNotEmpty(startPrefix, "Starting prefix must not be empty");
        this.checkArgNotEmpty(startPrefix, "Ending prefix must not be empty");
    }

    private void checkKey(String key) throws SnappydbException {
        this.checkArgNotEmpty(key, "Key must not be empty");
    }

    private void checkArgNotEmpty(String arg, String errorMsg) throws SnappydbException {
        if (TextUtils.isEmpty((CharSequence)arg)) {
            throw new SnappydbException(errorMsg);
        }
    }

    private void checkOffsetLimit(int offset, int limit) throws SnappydbException {
        if (offset < 0) {
            throw new SnappydbException("Offset must not be negative");
        }
        if (limit <= 0) {
            throw new SnappydbException("Limit must not be 0 or negative");
        }
    }

    private native void __close();

    private native void __open(String var1) throws SnappydbException;

    private native void __destroy(String var1) throws SnappydbException;

    private native boolean __isOpen() throws SnappydbException;

    private native void __put(String var1, byte[] var2) throws SnappydbException;

    private native void __put(String var1, String var2) throws SnappydbException;

    private native void __putShort(String var1, short var2) throws SnappydbException;

    private native void __putInt(String var1, int var2) throws SnappydbException;

    private native void __putBoolean(String var1, boolean var2) throws SnappydbException;

    private native void __putDouble(String var1, double var2) throws SnappydbException;

    private native void __putFloat(String var1, float var2) throws SnappydbException;

    private native void __putLong(String var1, long var2) throws SnappydbException;

    private native void __del(String var1) throws SnappydbException;

    private native byte[] __getBytes(String var1) throws SnappydbException;

    private native String __get(String var1) throws SnappydbException;

    private native short __getShort(String var1) throws SnappydbException;

    private native int __getInt(String var1) throws SnappydbException;

    private native boolean __getBoolean(String var1) throws SnappydbException;

    private native double __getDouble(String var1) throws SnappydbException;

    private native long __getLong(String var1) throws SnappydbException;

    private native float __getFloat(String var1) throws SnappydbException;

    private native boolean __exists(String var1) throws SnappydbException;

    private native String[] __findKeys(String var1, int var2, int var3) throws SnappydbException;

    private native int __countKeys(String var1) throws SnappydbException;

    private native String[] __findKeysBetween(String var1, String var2, int var3, int var4) throws SnappydbException;

    private native int __countKeysBetween(String var1, String var2) throws SnappydbException;

    native long __findKeysIterator(String var1, boolean var2) throws SnappydbException;

    native String[] __iteratorNextArray(long var1, String var3, boolean var4, int var5) throws SnappydbException;

    native boolean __iteratorIsValid(long var1, String var3, boolean var4);

    native void __iteratorClose(long var1);

    static {
        System.loadLibrary(LIB_NAME);
    }
}

