/*
 * Decompiled with CFR 0.152.
 */
package com.snappydb.internal;

import android.text.TextUtils;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.snappydb.DB;
import com.snappydb.SnappydbException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;

public class DBImpl
implements DB {
    private static final String LIB_NAME = "snappydb-native";
    private String dbPath;
    private Kryo kryo;

    public DBImpl(String path, Kryo ... kryo) throws SnappydbException {
        this.dbPath = path;
        if (null != kryo && kryo.length > 0) {
            this.kryo = kryo[0];
        } else {
            this.kryo = new Kryo();
            this.kryo.setAsmEnabled(true);
        }
        this.__open(this.dbPath);
    }

    @Override
    public void close() {
        this.__close();
    }

    @Override
    public void destroy() throws SnappydbException {
        this.__destroy(this.dbPath);
    }

    @Override
    public boolean isOpen() throws SnappydbException {
        return this.__isOpen();
    }

    @Override
    public void put(String key, String value) throws SnappydbException {
        this.checkArgs(key, value);
        this.__put(key, value);
    }

    @Override
    public void put(String key, Serializable value) throws SnappydbException {
        this.checkArgs(key, value);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.kryo.register(value.getClass());
        Output output = new Output((OutputStream)stream);
        try {
            this.kryo.writeObject(output, (Object)value);
            output.close();
            this.__put(key, stream.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SnappydbException(e.getMessage());
        }
    }

    @Override
    public void put(String key, byte[] value) throws SnappydbException {
        this.checkArgs(key, value);
        this.__put(key, value);
    }

    @Override
    public void put(String key, Serializable[] value) throws SnappydbException {
        this.checkArgs(key, value);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.kryo.register(value.getClass());
        Output output = new Output((OutputStream)stream);
        try {
            this.kryo.writeObject(output, (Object)value);
            output.close();
            this.__put(key, stream.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SnappydbException("Kryo exception " + e.getMessage());
        }
    }

    @Override
    public void putShort(String key, short val) throws SnappydbException {
        this.checkArgs(key);
        this.__putShort(key, val);
    }

    @Override
    public void putInt(String key, int val) throws SnappydbException {
        this.checkArgs(key);
        this.__putInt(key, val);
    }

    @Override
    public void putBoolean(String key, boolean val) throws SnappydbException {
        this.checkArgs(key);
        this.__putBoolean(key, val);
    }

    @Override
    public void putDouble(String key, double val) throws SnappydbException {
        this.checkArgs(key);
        this.__putDouble(key, val);
    }

    @Override
    public void putFloat(String key, float val) throws SnappydbException {
        this.checkArgs(key);
        this.__putFloat(key, val);
    }

    @Override
    public void putLong(String key, long val) throws SnappydbException {
        this.checkArgs(key);
        this.__putLong(key, val);
    }

    @Override
    public void del(String key) throws SnappydbException {
        this.checkArgs(key);
        this.__del(key);
    }

    @Override
    public <T extends Serializable> T get(String key, Class<T> className) throws SnappydbException {
        this.checkArgs(key, className);
        if (className.isArray()) {
            throw new SnappydbException("You should call getArray instead");
        }
        byte[] data = this.getBytes(key);
        this.kryo.register(className);
        Object obj = null;
        try (Input input = new Input(data);){
            obj = this.kryo.readObject(input, className);
            Serializable serializable = (Serializable)className.cast(obj);
            return (T)serializable;
        }
    }

    @Override
    public <T extends Serializable> T[] getArray(String key, Class<T> className) throws SnappydbException {
        this.checkArgs(key, className);
        byte[] data = this.__getBytes(key);
        this.kryo.register(className);
        Input input = new Input(data);
        Serializable[] obj = null;
        Serializable[] array = (Serializable[])Array.newInstance(className, 0);
        try {
            Serializable[] serializableArray = obj = (Serializable[])this.kryo.readObject(input, array.getClass());
            return serializableArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SnappydbException("Maybe you tried to retrieve an array using this method ? please use getArray instead " + e.getMessage());
        }
        finally {
            input.close();
        }
    }

    @Override
    public byte[] getBytes(String key) throws SnappydbException {
        this.checkArgs(key);
        return this.__getBytes(key);
    }

    @Override
    public String get(String key) throws SnappydbException {
        this.checkArgs(key);
        return this.__get(key);
    }

    @Override
    public short getShort(String key) throws SnappydbException {
        this.checkArgs(key);
        return this.__getShort(key);
    }

    @Override
    public int getInt(String key) throws SnappydbException {
        this.checkArgs(key);
        return this.__getInt(key);
    }

    @Override
    public boolean getBoolean(String key) throws SnappydbException {
        this.checkArgs(key);
        return this.__getBoolean(key);
    }

    @Override
    public double getDouble(String key) throws SnappydbException {
        this.checkArgs(key);
        return this.__getDouble(key);
    }

    @Override
    public long getLong(String key) throws SnappydbException {
        this.checkArgs(key);
        return this.__getLong(key);
    }

    @Override
    public float getFloat(String key) throws SnappydbException {
        this.checkArgs(key);
        return this.__getFloat(key);
    }

    @Override
    public boolean exists(String key) throws SnappydbException {
        this.checkArgs(key);
        return this.__exists(key);
    }

    @Override
    public Kryo getKryoInstance() {
        return this.kryo;
    }

    private void checkArgs(String key, Object value) throws SnappydbException {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new SnappydbException("Key must not be empty");
        }
        if (null == value) {
            throw new SnappydbException("Value must not be empty");
        }
    }

    private void checkArgs(String key) throws SnappydbException {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new SnappydbException("Key must not be empty");
        }
    }

    private native void __close();

    private native void __open(String var1) throws SnappydbException;

    private native void __destroy(String var1) throws SnappydbException;

    private native boolean __isOpen() throws SnappydbException;

    private native void __put(String var1, byte[] var2) throws SnappydbException;

    private native void __put(String var1, String var2) throws SnappydbException;

    private native void __putShort(String var1, short var2) throws SnappydbException;

    private native void __putInt(String var1, int var2) throws SnappydbException;

    private native void __putBoolean(String var1, boolean var2) throws SnappydbException;

    private native void __putDouble(String var1, double var2) throws SnappydbException;

    private native void __putFloat(String var1, float var2) throws SnappydbException;

    private native void __putLong(String var1, long var2) throws SnappydbException;

    private native void __del(String var1) throws SnappydbException;

    private native byte[] __getBytes(String var1) throws SnappydbException;

    private native String __get(String var1) throws SnappydbException;

    private native short __getShort(String var1) throws SnappydbException;

    private native int __getInt(String var1) throws SnappydbException;

    private native boolean __getBoolean(String var1) throws SnappydbException;

    private native double __getDouble(String var1) throws SnappydbException;

    private native long __getLong(String var1) throws SnappydbException;

    private native float __getFloat(String var1) throws SnappydbException;

    private native boolean __exists(String var1) throws SnappydbException;

    static {
        System.loadLibrary(LIB_NAME);
    }
}

