/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.SheetAutomationRuleResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.AutomationRule;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import java.util.HashMap;
import java.util.Map;

public class SheetAutomationRuleResourcesImpl
extends AbstractResources
implements SheetAutomationRuleResources {
    private static final String SHEETS_PATH = "sheets/";
    private static final String AUTOMATION_RULES = "automationrules";

    public SheetAutomationRuleResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public PagedResult<AutomationRule> listAutomationRules(long sheetId, PaginationParameters pagination) throws SmartsheetException {
        String path = SHEETS_PATH + sheetId + "/automationrules";
        Map<Object, Object> parameters = new HashMap();
        if (pagination != null) {
            parameters = pagination.toHashMap();
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper(path, AutomationRule.class);
    }

    @Override
    public AutomationRule getAutomationRule(long sheetId, long automationRuleId) throws SmartsheetException {
        return this.getResource(SHEETS_PATH + sheetId + "/automationrules/" + automationRuleId, AutomationRule.class);
    }

    @Override
    public AutomationRule updateAutomationRule(long sheetId, AutomationRule automationRule) throws SmartsheetException {
        Util.throwIfNull(automationRule);
        return this.updateResource(SHEETS_PATH + sheetId + "/automationrules/" + String.valueOf(automationRule.getId()), AutomationRule.class, automationRule);
    }

    @Override
    public void deleteAutomationRule(long sheetId, long automationRuleId) throws SmartsheetException {
        this.deleteResource(SHEETS_PATH + sheetId + "/automationrules/" + automationRuleId, AutomationRule.class);
    }
}

