/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.RowDiscussionResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.Discussion;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.enums.DiscussionInclusion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;

public class RowDiscussionResourcesImpl
extends AbstractResources
implements RowDiscussionResources {
    public RowDiscussionResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public Discussion createDiscussion(long sheetId, long rowId, Discussion discussion) throws SmartsheetException {
        return this.createResource(this.createPath(sheetId, rowId), Discussion.class, discussion);
    }

    @Override
    public Discussion createDiscussionWithAttachment(long sheetId, long rowId, Discussion discussion, File file, String contentType) throws SmartsheetException, IOException {
        String path = this.createPath(sheetId, rowId);
        Util.throwIfNull(sheetId, discussion, file, contentType);
        return this.createResourceWithAttachment(path, Discussion.class, discussion, "discussion", new FileInputStream(file), contentType, file.getName());
    }

    @Override
    public PagedResult<Discussion> listDiscussions(long sheetId, long rowId, PaginationParameters pagination, EnumSet<DiscussionInclusion> includes) throws SmartsheetException {
        Object path = this.createPath(sheetId, rowId);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        if (pagination != null) {
            parameters.putAll(pagination.toHashMap());
        }
        path = (String)path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper((String)path, Discussion.class);
    }

    private String createPath(long sheetId, long rowId) {
        return "sheets/" + sheetId + "/rows/" + rowId + "/discussions";
    }
}

