/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.smartsheet.api.models.Attachment;
import com.smartsheet.api.models.Cell;
import com.smartsheet.api.models.Column;
import com.smartsheet.api.models.Discussion;
import com.smartsheet.api.models.IdentifiableModel;
import com.smartsheet.api.models.User;
import com.smartsheet.api.models.enums.AccessLevel;
import com.smartsheet.api.models.format.Format;
import java.util.Date;
import java.util.List;

public abstract class AbstractRow<TColumn extends Column, TCell extends Cell>
extends IdentifiableModel<Long> {
    private Long sheetId;
    private Integer rowNumber;
    private Integer parentRowNumber;
    private List<TCell> cells;
    private List<Discussion> discussions;
    private List<Attachment> attachments;
    private List<TColumn> columns;
    private Date createdAt;
    private Date modifiedAt;
    private Boolean expanded;
    private Integer version;
    private AccessLevel accessLevel;
    private Boolean locked;
    private Boolean lockedForUser;
    private Format format;
    private Long parentId;
    private Long siblingId;
    private String permalink;
    private Boolean filteredOut;
    private Boolean inCriticalPath;
    private Format conditionalFormat;
    private Boolean toTop;
    private Boolean toBottom;
    private Boolean above;
    private Integer indent;
    private Integer outdent;
    private User createdBy;
    private User modifiedBy;

    @Override
    @JsonIgnore(value=false)
    public Long getId() {
        return (Long)super.getId();
    }

    @Override
    @JsonIgnore(value=false)
    public IdentifiableModel<Long> setId(Long id) {
        super.setId(id);
        return this;
    }

    @JsonIgnore
    public Long getRowId() {
        return (Long)super.getId();
    }

    @JsonIgnore
    public <T extends AbstractRow<TColumn, TCell>> T setRowId(Long id) {
        super.setId(id);
        return (T)this;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
        return (T)this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setVersion(Integer version) {
        this.version = version;
        return (T)this;
    }

    public Boolean isExpanded() {
        return this.expanded;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setExpanded(Boolean expanded) {
        this.expanded = expanded;
        return (T)this;
    }

    public TColumn getColumnByIndex(int index) {
        if (this.columns == null) {
            return null;
        }
        return (TColumn)((Column)this.columns.stream().filter(column -> column.getIndex() == index).findFirst().orElse(null));
    }

    public TColumn getColumnById(long columnId) {
        if (this.columns == null) {
            return null;
        }
        return (TColumn)((Column)this.columns.stream().filter(column -> (Long)column.getId() == columnId).findFirst().orElse(null));
    }

    public Long getSheetId() {
        return this.sheetId;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setSheetId(Long sheetId) {
        this.sheetId = sheetId;
        return (T)this;
    }

    public Integer getRowNumber() {
        return this.rowNumber;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setRowNumber(Integer rowNumber) {
        this.rowNumber = rowNumber;
        return (T)this;
    }

    public Integer getParentRowNumber() {
        return this.parentRowNumber;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setParentRowNumber(Integer parentRowNumber) {
        this.parentRowNumber = parentRowNumber;
        return (T)this;
    }

    public List<TCell> getCells() {
        return this.cells;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setCells(List<TCell> cells) {
        this.cells = cells;
        return (T)this;
    }

    public List<Discussion> getDiscussions() {
        return this.discussions;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setDiscussions(List<Discussion> discussions) {
        this.discussions = discussions;
        return (T)this;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return (T)this;
    }

    public List<TColumn> getColumns() {
        return this.columns;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setColumns(List<TColumn> columns) {
        this.columns = columns;
        return (T)this;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return (T)this;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
        return (T)this;
    }

    public Boolean isLocked() {
        return this.locked;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setLocked(Boolean locked) {
        this.locked = locked;
        return (T)this;
    }

    public Boolean isLockedForUser() {
        return this.lockedForUser;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setLockedForUser(Boolean lockedForUser) {
        this.lockedForUser = lockedForUser;
        return (T)this;
    }

    public Format getFormat() {
        return this.format;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setFormat(Format format) {
        this.format = format;
        return (T)this;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setParentId(Long parentId) {
        this.parentId = parentId;
        return (T)this;
    }

    public Long getSiblingId() {
        return this.siblingId;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setSiblingId(Long siblingId) {
        this.siblingId = siblingId;
        return (T)this;
    }

    public String getPermalink() {
        return this.permalink;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setPermalink(String permalink) {
        this.permalink = permalink;
        return (T)this;
    }

    public Boolean isFilteredOut() {
        return this.filteredOut;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setFilteredOut(Boolean filteredOut) {
        this.filteredOut = filteredOut;
        return (T)this;
    }

    public Boolean isInCriticalPath() {
        return this.inCriticalPath;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setInCriticalPath(Boolean inCriticalPath) {
        this.inCriticalPath = inCriticalPath;
        return (T)this;
    }

    public Format getConditionalFormat() {
        return this.conditionalFormat;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setConditionalFormat(Format conditionalFormat) {
        this.conditionalFormat = conditionalFormat;
        return (T)this;
    }

    public Boolean getToTop() {
        return this.toTop;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setToTop(Boolean toTop) {
        this.toTop = toTop;
        return (T)this;
    }

    public Boolean getToBottom() {
        return this.toBottom;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setToBottom(Boolean toBottom) {
        this.toBottom = toBottom;
        return (T)this;
    }

    public Boolean getAbove() {
        return this.above;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setAbove(Boolean above) {
        this.above = above;
        return (T)this;
    }

    public Integer getIndent() {
        return this.indent;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setIndent(Integer indent) {
        this.indent = indent;
        return (T)this;
    }

    public Integer getOutdent() {
        return this.outdent;
    }

    public <T extends AbstractRow<TColumn, TCell>> T setOutdent(Integer outdent) {
        this.outdent = outdent;
        return (T)this;
    }

    public User getCreatedBy() {
        return this.createdBy;
    }

    public User getModifiedBy() {
        return this.modifiedBy;
    }
}

