/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.DiscussionAttachmentResources;
import com.smartsheet.api.DiscussionCommentResources;
import com.smartsheet.api.SheetDiscussionResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.DiscussionAttachmentResourcesImpl;
import com.smartsheet.api.internal.DiscussionCommentResourcesImpl;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.Discussion;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.enums.DiscussionInclusion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class SheetDiscussionResourcesImpl
extends AbstractResources
implements SheetDiscussionResources {
    DiscussionAttachmentResources attachments;
    DiscussionCommentResources comments;
    private static final String SHEETS_PATH = "sheets/";
    private static final String DISCUSSIONS = "discussions";

    public SheetDiscussionResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
        this.attachments = new DiscussionAttachmentResourcesImpl(smartsheet);
        this.comments = new DiscussionCommentResourcesImpl(smartsheet);
    }

    @Override
    public Discussion createDiscussion(long sheetId, Discussion discussion) throws SmartsheetException {
        Util.throwIfNull((Object)sheetId, (Object)discussion);
        return this.createResource(SHEETS_PATH + sheetId + "/discussions", Discussion.class, discussion);
    }

    @Override
    public Discussion createDiscussionWithAttachment(long sheetId, Discussion discussion, File file, String contentType) throws SmartsheetException, IOException {
        Util.throwIfNull(discussion, file, contentType);
        String path = SHEETS_PATH + sheetId + "/discussions";
        return this.createDiscussionWithAttachment(path, discussion, new FileInputStream(file), contentType, file.getName());
    }

    private Discussion createDiscussionWithAttachment(String path, Discussion discussion, InputStream inputStream, String contentType, String attachmentName) throws SmartsheetException {
        return this.createResourceWithAttachment(path, Discussion.class, discussion, "discussion", inputStream, contentType, attachmentName);
    }

    @Override
    public Discussion getDiscussion(long sheetId, long discussionId) throws SmartsheetException {
        return this.getResource(SHEETS_PATH + sheetId + "/discussions/" + discussionId, Discussion.class);
    }

    @Override
    public void deleteDiscussion(long sheetId, long discussionId) throws SmartsheetException {
        this.deleteResource(SHEETS_PATH + sheetId + "/discussions/" + discussionId, Discussion.class);
    }

    @Override
    public PagedResult<Discussion> listDiscussions(long sheetId, PaginationParameters pagination, EnumSet<DiscussionInclusion> includes) throws SmartsheetException {
        String path = SHEETS_PATH + sheetId + "/discussions";
        Map<String, Object> parameters = new HashMap<String, String>();
        if (pagination != null) {
            parameters = pagination.toHashMap();
        }
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper(path, Discussion.class);
    }

    @Override
    public DiscussionCommentResources commentResources() throws SmartsheetException {
        return this.comments;
    }

    @Override
    public DiscussionAttachmentResources attachmentResources() throws SmartsheetException {
        return this.attachments;
    }
}

