/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.smartsheet.api.models.Folder;
import com.smartsheet.api.models.Report;
import com.smartsheet.api.models.Sheet;
import com.smartsheet.api.models.Sight;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ChildrenResourceDeserializer
extends JsonDeserializer<List<Object>> {
    public List<Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ArrayList<Object> children = new ArrayList<Object>();
        if (jp.getCurrentToken() == JsonToken.START_ARRAY) {
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                if (jp.getCurrentToken() != JsonToken.START_OBJECT) continue;
                JsonNode node = (JsonNode)jp.readValueAsTree();
                JsonNode resourceTypeNode = node.get("resourceType");
                if (resourceTypeNode != null && resourceTypeNode.isTextual()) {
                    String resourceType = resourceTypeNode.asText().toLowerCase();
                    Object child = null;
                    try {
                        switch (resourceType) {
                            case "sheet": {
                                child = mapper.treeToValue((TreeNode)node, Sheet.class);
                                break;
                            }
                            case "folder": {
                                child = mapper.treeToValue((TreeNode)node, Folder.class);
                                break;
                            }
                            case "report": {
                                child = mapper.treeToValue((TreeNode)node, Report.class);
                                break;
                            }
                            case "sight": {
                                child = mapper.treeToValue((TreeNode)node, Sight.class);
                                break;
                            }
                            default: {
                                child = mapper.treeToValue((TreeNode)node, Object.class);
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        child = mapper.treeToValue((TreeNode)node, Object.class);
                    }
                    if (child == null) continue;
                    children.add(child);
                    continue;
                }
                Object child = mapper.treeToValue((TreeNode)node, Object.class);
                children.add(child);
            }
        }
        return children;
    }
}

