/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.AttachmentVersioningResources;
import com.smartsheet.api.SheetAttachmentResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.AttachmentVersioningResourcesImpl;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.Attachment;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class SheetAttachmentResourcesImpl
extends AbstractResources
implements SheetAttachmentResources {
    private AttachmentVersioningResources versioning;
    private static final String SHEETS_PATH = "sheets/";
    private static final String ATTACHMENTS_PATH = "/attachments";

    public SheetAttachmentResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
        this.versioning = new AttachmentVersioningResourcesImpl(smartsheet);
    }

    @Override
    public Attachment attachUrl(long sheetId, Attachment attachment) throws SmartsheetException {
        return this.createResource(SHEETS_PATH + sheetId + ATTACHMENTS_PATH, Attachment.class, attachment);
    }

    @Override
    public void deleteAttachment(long sheetId, long attachmentId) throws SmartsheetException {
        this.deleteResource(SHEETS_PATH + sheetId + "/attachments/" + attachmentId, Attachment.class);
    }

    @Override
    public Attachment getAttachment(long sheetId, long attachmentId) throws SmartsheetException {
        return this.getResource(SHEETS_PATH + sheetId + "/attachments/" + attachmentId, Attachment.class);
    }

    @Override
    public PagedResult<Attachment> listAttachments(long sheetId, PaginationParameters parameters) throws SmartsheetException {
        String path = SHEETS_PATH + sheetId + ATTACHMENTS_PATH;
        if (parameters != null) {
            path = path + parameters.toQueryString();
        }
        return this.listResourcesWithWrapper(path, Attachment.class);
    }

    @Override
    public Attachment attachFile(long sheetId, File file, String contentType) throws FileNotFoundException, SmartsheetException {
        Util.throwIfNull(sheetId, file, contentType);
        Util.throwIfEmpty(contentType);
        return this.attachFile(sheetId, (InputStream)new FileInputStream(file), contentType, file.length(), file.getName());
    }

    @Override
    public Attachment attachFile(long sheetId, InputStream inputStream, String contentType, long contentLength, String attachmentName) throws SmartsheetException {
        Util.throwIfNull((Object)inputStream, (Object)contentType);
        return super.attachFile(SHEETS_PATH + sheetId + ATTACHMENTS_PATH, inputStream, contentType, contentLength, attachmentName);
    }

    @Override
    public AttachmentVersioningResources versioningResources() throws SmartsheetException {
        return this.versioning;
    }
}

