/*
 * Copyright (C) 2025 Smartsheet
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Enumeration types used in Smartsheet API model classes.
 * <p>
 * This package contains enumeration types that represent various constants and options
 * used throughout the Smartsheet API, including:
 * </p>
 * <ul>
 *   <li>Column types and system column types</li>
 *   <li>Access levels and share scopes</li>
 *   <li>Object inclusion and exclusion options</li>
 *   <li>Sheet and report filtering options</li>
 *   <li>Automation action types and frequencies</li>
 *   <li>Webhook statuses and event types</li>
 *   <li>And many other enumerated values</li>
 * </ul>
 * <p>
 * These enumerations provide type-safe constants for API parameters and response values.
 * </p>
 *
 * @see com.smartsheet.api.models
 */
package com.smartsheet.api.models.enums;
