/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.file;

import com.google.gson.reflect.TypeToken;
import com.smartling.api.sdk.ProxyConfiguration;
import com.smartling.api.sdk.TokenProviderAwareClient;
import com.smartling.api.sdk.auth.AuthApiClient;
import com.smartling.api.sdk.auth.AuthenticationToken;
import com.smartling.api.sdk.auth.ExistingTokenProvider;
import com.smartling.api.sdk.auth.OAuthTokenProvider;
import com.smartling.api.sdk.auth.TokenProvider;
import com.smartling.api.sdk.dto.file.FileLastModified;
import com.smartling.api.sdk.dto.file.StringResponse;
import com.smartling.api.sdk.dto.file.UploadFileData;
import com.smartling.api.sdk.exceptions.SmartlingApiException;
import com.smartling.api.sdk.file.FileApiClient;
import com.smartling.api.sdk.file.FileType;
import com.smartling.api.sdk.file.parameters.FileDeletePayload;
import com.smartling.api.sdk.file.parameters.FileImportParameterBuilder;
import com.smartling.api.sdk.file.parameters.FileLastModifiedParameterBuilder;
import com.smartling.api.sdk.file.parameters.FileListSearchParameterBuilder;
import com.smartling.api.sdk.file.parameters.FileRenamePayload;
import com.smartling.api.sdk.file.parameters.FileUploadParameterBuilder;
import com.smartling.api.sdk.file.parameters.GetFileParameterBuilder;
import com.smartling.api.sdk.file.parameters.GetFilesArchiveParameterBuilder;
import com.smartling.api.sdk.file.parameters.GetOriginalFileParameterBuilder;
import com.smartling.api.sdk.file.response.ApiV2ResponseWrapper;
import com.smartling.api.sdk.file.response.EmptyResponse;
import com.smartling.api.sdk.file.response.FileImportSmartlingData;
import com.smartling.api.sdk.file.response.FileList;
import com.smartling.api.sdk.file.response.FileLocaleStatus;
import com.smartling.api.sdk.file.response.FileStatus;
import com.smartling.api.sdk.util.DateFormatter;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;

public final class FileApiClientImpl
extends TokenProviderAwareClient
implements FileApiClient {
    private static final String FILES_API_V2_FILE_DELETE = "/files-api/v2/projects/%s/file/delete";
    private static final String FILES_API_V2_FILE_RENAME = "/files-api/v2/projects/%s/file/rename";
    private static final String FILES_API_V2_FILE_LAST_MODIFIED = "/files-api/v2/projects/%s/file/last-modified";
    private static final String FILES_API_V2_GET_FILE = "/files-api/v2/projects/%s/locales/%s/file";
    private static final String FILES_API_V2_GET_FILES_ZIP = "/files-api/v2/projects/%s/files/zip";
    private static final String FILES_API_V2_GET_ORIGINAL_FILE = "/files-api/v2/projects/%s/file";
    private static final String FILES_API_V2_FILES_LIST = "/files-api/v2/projects/%s/files/list";
    private static final String FILES_API_V2_FILE_LOCALE_STATUS = "/files-api/v2/projects/%s/locales/%s/file/status";
    private static final String FILES_API_V2_FILE_STATUS = "/files-api/v2/projects/%s/file/status";
    private static final String FILES_API_V2_FILE_UPLOAD = "/files-api/v2/projects/%s/file";
    private static final String FILES_API_V2_FILE_IMPORT = "/files-api/v2/projects/%s/locales/%s/file/import";
    private static final String REQUEST_PARAMS_SEPARATOR = "?";
    private static final String TEXT_PLAIN_TYPE = "text/plain";
    private final String projectId;

    private FileApiClientImpl(TokenProvider tokenProvider, String projectId, ProxyConfiguration proxyConfiguration, String baseUrl) {
        super(baseUrl, proxyConfiguration, tokenProvider);
        this.projectId = Objects.requireNonNull(projectId, "Project ID can not be null");
    }

    @Override
    public UploadFileData uploadFile(File fileToUpload, FileUploadParameterBuilder fileUploadParameterBuilder) throws SmartlingApiException {
        FileBody fileBody = new FileBody(fileToUpload, this.createContentType(fileUploadParameterBuilder.getFileType(), this.getCharset(fileUploadParameterBuilder)), fileToUpload.getName());
        return this.uploadFile(fileUploadParameterBuilder, (ContentBody)fileBody);
    }

    @Override
    public UploadFileData uploadFile(InputStream inputStream, String fileName, FileUploadParameterBuilder fileUploadParameterBuilder) throws SmartlingApiException {
        InputStreamBody inputStreamBody = new InputStreamBody(inputStream, this.createContentType(fileUploadParameterBuilder.getFileType(), this.getCharset(fileUploadParameterBuilder)), fileName);
        return this.uploadFile(fileUploadParameterBuilder, (ContentBody)inputStreamBody);
    }

    @Override
    public EmptyResponse deleteFile(String fileUri) throws SmartlingApiException {
        HttpPost httpPost = FileApiClientImpl.createJsonPostRequest(this.getApiUrl(FILES_API_V2_FILE_DELETE), new FileDeletePayload(fileUri));
        StringResponse response = this.executeRequest((HttpRequestBase)httpPost);
        return FileApiClientImpl.getApiV2Response(response.getContents(), new TypeToken<ApiV2ResponseWrapper<EmptyResponse>>(){}).retrieveData();
    }

    @Override
    public EmptyResponse renameFile(String fileUri, String newFileUri) throws SmartlingApiException {
        HttpPost httpPost = FileApiClientImpl.createJsonPostRequest(this.getApiUrl(FILES_API_V2_FILE_RENAME), new FileRenamePayload(fileUri, newFileUri));
        StringResponse response = this.executeRequest((HttpRequestBase)httpPost);
        return FileApiClientImpl.getApiV2Response(response.getContents(), new TypeToken<ApiV2ResponseWrapper<EmptyResponse>>(){}).retrieveData();
    }

    @Override
    public FileLastModified getLastModified(FileLastModifiedParameterBuilder builder) throws SmartlingApiException {
        HttpGet httpGet = new HttpGet(this.buildUrl(this.getApiUrl(FILES_API_V2_FILE_LAST_MODIFIED), this.buildParamsQuery(builder.getNameValueList().toArray(new NameValuePair[builder.getNameValueList().size()]))));
        StringResponse response = this.executeRequest((HttpRequestBase)httpGet);
        return FileApiClientImpl.getApiV2Response(response.getContents(), new TypeToken<ApiV2ResponseWrapper<FileLastModified>>(){}).retrieveData();
    }

    @Override
    public StringResponse getFilesArchive(GetFilesArchiveParameterBuilder builder) throws SmartlingApiException {
        List<NameValuePair> paramsList = builder.getNameValueList();
        String params = this.buildParamsQuery(paramsList.toArray(new NameValuePair[paramsList.size()]));
        HttpGet httpGet = new HttpGet(this.buildUrl(this.getApiUrl(FILES_API_V2_GET_FILES_ZIP), params));
        StringResponse response = this.executeRequest((HttpRequestBase)httpGet);
        if (response.isSuccess()) {
            return response;
        }
        FileApiClientImpl.getApiV2Response(response.getContents(), new TypeToken<ApiV2ResponseWrapper<EmptyResponse>>(){}).retrieveData();
        throw new SmartlingApiException("Failed to get file content");
    }

    @Override
    public StringResponse getFile(GetFileParameterBuilder getFileParameterBuilder) throws SmartlingApiException {
        List<NameValuePair> paramsList = getFileParameterBuilder.getNameValueList();
        String params = this.buildParamsQuery(paramsList.toArray(new NameValuePair[paramsList.size()]));
        HttpGet httpGet = new HttpGet(this.buildUrl(this.getApiUrl(FILES_API_V2_GET_FILE, getFileParameterBuilder.getLocale()), params));
        StringResponse response = this.executeRequest((HttpRequestBase)httpGet);
        if (response.isSuccess()) {
            return response;
        }
        FileApiClientImpl.getApiV2Response(response.getContents(), new TypeToken<ApiV2ResponseWrapper<EmptyResponse>>(){}).retrieveData();
        throw new SmartlingApiException("Failed to get file content");
    }

    @Override
    public StringResponse getOriginalFile(GetOriginalFileParameterBuilder getFileParameterBuilder) throws SmartlingApiException {
        List<NameValuePair> paramsList = getFileParameterBuilder.getNameValueList();
        String params = this.buildParamsQuery(paramsList.toArray(new NameValuePair[paramsList.size()]));
        HttpGet httpGet = new HttpGet(this.buildUrl(this.getApiUrl("/files-api/v2/projects/%s/file"), params));
        StringResponse response = this.executeRequest((HttpRequestBase)httpGet);
        if (response.isSuccess()) {
            return response;
        }
        FileApiClientImpl.getApiV2Response(response.getContents(), new TypeToken<ApiV2ResponseWrapper<EmptyResponse>>(){}).retrieveData();
        throw new SmartlingApiException("Failed to get file content");
    }

    @Override
    public FileList getFilesList(FileListSearchParameterBuilder fileListSearchParameterBuilder) throws SmartlingApiException {
        String params = this.buildFileListParams(fileListSearchParameterBuilder);
        HttpGet httpGet = new HttpGet(this.buildUrl(this.getApiUrl(FILES_API_V2_FILES_LIST), params));
        StringResponse response = this.executeRequest((HttpRequestBase)httpGet);
        return FileApiClientImpl.getApiV2Response(response.getContents(), new TypeToken<ApiV2ResponseWrapper<FileList>>(){}).retrieveData();
    }

    @Override
    public FileLocaleStatus getFileLocaleStatus(String fileUri, String locale) throws SmartlingApiException {
        String params = this.buildParamsQuery(new NameValuePair[]{new BasicNameValuePair("fileUri", fileUri)});
        HttpGet httpGet = new HttpGet(this.buildUrl(this.getApiUrl(FILES_API_V2_FILE_LOCALE_STATUS, locale), params));
        StringResponse response = this.executeRequest((HttpRequestBase)httpGet);
        return FileApiClientImpl.getApiV2Response(response.getContents(), new TypeToken<ApiV2ResponseWrapper<FileLocaleStatus>>(){}).retrieveData();
    }

    @Override
    public FileStatus getFileStatus(String fileUri) throws SmartlingApiException {
        String params = this.buildParamsQuery(new NameValuePair[]{new BasicNameValuePair("fileUri", fileUri)});
        HttpGet httpGet = new HttpGet(this.buildUrl(this.getApiUrl(FILES_API_V2_FILE_STATUS), params));
        StringResponse response = this.executeRequest((HttpRequestBase)httpGet);
        return FileApiClientImpl.getApiV2Response(response.getContents(), new TypeToken<ApiV2ResponseWrapper<FileStatus>>(){}).retrieveData();
    }

    @Override
    public FileImportSmartlingData importTranslations(FileImportParameterBuilder fileImportParameterBuilder) throws SmartlingApiException {
        FileBody fileBody = new FileBody(fileImportParameterBuilder.getFile(), this.createContentType(fileImportParameterBuilder.getFileType(), Charset.forName(fileImportParameterBuilder.getCharset())), fileImportParameterBuilder.getFile().getName());
        List<NameValuePair> paramsList = fileImportParameterBuilder.getNameValueList();
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().addPart("file", (ContentBody)fileBody);
        if (CollectionUtils.isNotEmpty(paramsList)) {
            for (NameValuePair param : paramsList) {
                if (param.getValue() == null) continue;
                multipartEntityBuilder.addPart(param.getName(), (ContentBody)new StringBody(param.getValue(), ContentType.create((String)TEXT_PLAIN_TYPE, (Charset)Charset.forName("UTF-8"))));
            }
        }
        HttpPost httpPost = new HttpPost(this.baseUrl + String.format(FILES_API_V2_FILE_IMPORT, this.projectId, fileImportParameterBuilder.getLocale()));
        httpPost.setEntity(multipartEntityBuilder.build());
        StringResponse response = this.executeRequest((HttpRequestBase)httpPost);
        return FileApiClientImpl.getApiV2Response(response.getContents(), new TypeToken<ApiV2ResponseWrapper<FileImportSmartlingData>>(){}).retrieveData();
    }

    private Charset getCharset(FileUploadParameterBuilder fileUploadParameterBuilder) {
        String charsetName = fileUploadParameterBuilder.getCharset();
        return StringUtils.isEmpty((CharSequence)charsetName) ? Charset.forName(charsetName) : null;
    }

    private ContentType createContentType(FileType fileType, Charset charset) {
        return fileType.isTextFormat() && charset != null ? ContentType.create((String)fileType.getMimeType(), (Charset)charset) : ContentType.create((String)fileType.getMimeType());
    }

    private UploadFileData uploadFile(FileUploadParameterBuilder fileUploadParameterBuilder, ContentBody contentBody) throws SmartlingApiException {
        List<NameValuePair> paramsList = fileUploadParameterBuilder.getNameValueList();
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().addPart("file", contentBody);
        if (CollectionUtils.isNotEmpty(paramsList)) {
            for (NameValuePair param : paramsList) {
                if (param.getValue() == null) continue;
                multipartEntityBuilder.addPart(param.getName(), (ContentBody)new StringBody(param.getValue(), ContentType.create((String)TEXT_PLAIN_TYPE, (Charset)Charset.forName("UTF-8"))));
            }
        }
        HttpPost httpPost = new HttpPost(this.baseUrl + String.format("/files-api/v2/projects/%s/file", this.projectId));
        httpPost.setEntity(multipartEntityBuilder.build());
        StringResponse response = this.executeRequest((HttpRequestBase)httpPost);
        return FileApiClientImpl.getApiV2Response(response.getContents(), new TypeToken<ApiV2ResponseWrapper<UploadFileData>>(){}).retrieveData();
    }

    private String buildParamsQuery(NameValuePair ... nameValuePairs) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        for (NameValuePair nameValuePair : nameValuePairs) {
            if (nameValuePair.getValue() == null) continue;
            params.add(nameValuePair);
        }
        return URLEncodedUtils.format(params, (String)"UTF-8");
    }

    private String buildUrl(String apiServerUrl, String apiParameters) {
        return apiServerUrl + REQUEST_PARAMS_SEPARATOR + apiParameters;
    }

    private String buildFileListParams(FileListSearchParameterBuilder fileListSearchParameterBuilder) {
        ArrayList<Object> nameValuePairs = new ArrayList<Object>();
        nameValuePairs.add(new BasicNameValuePair("uriMask", fileListSearchParameterBuilder.getUriMask()));
        nameValuePairs.add(new BasicNameValuePair("lastUploadedAfter", DateFormatter.format(fileListSearchParameterBuilder.getLastUploadedAfter())));
        nameValuePairs.add(new BasicNameValuePair("lastUploadedBefore", DateFormatter.format(fileListSearchParameterBuilder.getLastUploadedBefore())));
        nameValuePairs.add(new BasicNameValuePair("offset", null == fileListSearchParameterBuilder.getOffset() ? null : String.valueOf(fileListSearchParameterBuilder.getOffset())));
        nameValuePairs.add(new BasicNameValuePair("limit", null == fileListSearchParameterBuilder.getLimit() ? null : String.valueOf(fileListSearchParameterBuilder.getLimit())));
        nameValuePairs.addAll(this.convertFileTypesParams("fileTypes", fileListSearchParameterBuilder.getFileTypes()));
        return this.buildParamsQuery(nameValuePairs.toArray(new NameValuePair[nameValuePairs.size()]));
    }

    private List<NameValuePair> convertFileTypesParams(String prefix, List<FileType> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        for (FileType value : values) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair(prefix + "[]", value.getIdentifier()));
        }
        return nameValuePairs;
    }

    private String getApiUrl(String uri) {
        return this.baseUrl + String.format(uri, this.projectId);
    }

    private String getApiUrl(String uri, String locale) {
        return this.baseUrl + String.format(uri, this.projectId, locale);
    }

    public static class Builder {
        private final String projectId;
        private String baseSmartlingApiUrl = "https://api.smartling.com";
        private TokenProvider tokenProvider;
        private String userId;
        private String userSecret;
        private ProxyConfiguration proxyConfiguration;

        public Builder(String projectId) {
            this.projectId = projectId;
        }

        public Builder baseSmartlingApiUrl(String baseAuthApiUrl) {
            this.baseSmartlingApiUrl = baseAuthApiUrl;
            return this;
        }

        public Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public Builder authWithUserIdAndSecret(String userId, String userSecret) {
            this.userId = userId;
            this.userSecret = userSecret;
            this.tokenProvider = null;
            return this;
        }

        public Builder authWithExistingToken(AuthenticationToken authenticationToken) {
            this.tokenProvider = new ExistingTokenProvider(authenticationToken);
            return this;
        }

        public Builder withCustomTokenProvider(TokenProvider tokenProvider) {
            this.tokenProvider = tokenProvider;
            return this;
        }

        public FileApiClient build() {
            TokenProvider tokenProvider = this.tokenProvider;
            if (tokenProvider == null && this.userId != null && this.userSecret != null) {
                tokenProvider = new OAuthTokenProvider(this.userId, this.userSecret, new AuthApiClient(this.proxyConfiguration, this.baseSmartlingApiUrl));
            }
            return new FileApiClientImpl(tokenProvider, this.projectId, this.proxyConfiguration, this.baseSmartlingApiUrl);
        }
    }
}

