/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.files.v2.pto;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum FileType {
    JAVA_PROPERTIES("text/plain", true),
    IOS("text/plain", true),
    ANDROID("application/xml", true),
    GETTEXT("text/plain", true),
    XLIFF("application/xml", true),
    YAML("text/plain", true),
    JSON("application/json", true),
    XML("application/xml", true),
    HTML("text/html", true),
    FREEMARKER("application/octet-stream", false),
    DOCX("application/octet-stream", false),
    DOC("application/octet-stream", false),
    PPTX("application/octet-stream", false),
    XLSX("application/octet-stream", false),
    XLS("application/octet-stream", false),
    IDML("application/octet-stream", false),
    RESX("application/xml", true),
    QT("application/xml", true),
    CSV("text/csv", true),
    PLAIN_TEXT("text/plain", true),
    PPT("application/octet-stream", false),
    PRES("text/plain", true),
    STRINGSDICT("application/xml", true),
    MADCAP("application/octet-stream", false),
    SRT("text/plain", false),
    MARKDOWN("text/markdown", true),
    PHP_RESOURCE("text/plain", false),
    TMX("application/xml", false),
    XLIFF_CAT("application/xml", false),
    DITA("application/xml", false),
    PDF("application/octet-stream", false),
    FLUENT("text/plain", true),
    DOCM("application/octet-stream", false),
    SVG("image/svg+xml", false),
    VTT("text/vtt", false),
    DITA_ZIP("application/octet-stream", false),
    RTF("application/rtf", false),
    FLARE("application/octet-stream", false),
    XLIFF2("application/xml", false),
    ARB("application/json", false),
    NONE("application/octet-stream", false),
    XLSX_TEMPLATE("application/octet-stream", false),
    XCSTRINGS("application/json", true),
    INDD("application/octet-stream", false),
    VSDX("application/octet-stream", false),
    VSDM("application/octet-stream", false);

    private final String identifier = FileType.toLowerCamel(this.name());
    private final String mimeType;
    private final boolean isTextFormat;
    public static final Map<String, FileType> BY_NAME_LOOKUP;

    private static String toLowerCamel(String s) {
        StringBuilder buf = new StringBuilder();
        String[] parts = s.split("_");
        for (int i = 0; i < parts.length; ++i) {
            buf.append(i == 0 ? parts[i].toLowerCase() : StringUtils.capitalize((String)parts[i].toLowerCase()));
        }
        return buf.toString();
    }

    private FileType(String mimeType, boolean isTextFormat) {
        this.mimeType = mimeType;
        this.isTextFormat = isTextFormat;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean isTextFormat() {
        return this.isTextFormat;
    }

    public static FileType lookup(String fileTypeString) {
        return BY_NAME_LOOKUP.get(StringUtils.lowerCase((String)fileTypeString));
    }

    static {
        BY_NAME_LOOKUP = new HashMap<String, FileType>();
        for (FileType value : FileType.values()) {
            BY_NAME_LOOKUP.put(value.identifier.toLowerCase(), value);
            BY_NAME_LOOKUP.put(value.name().toLowerCase(), value);
        }
    }
}

