/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.client;

import com.smartling.api.v2.authentication.AuthenticationApi;
import com.smartling.api.v2.authentication.AuthenticationApiFactory;
import com.smartling.api.v2.client.ApiFactory;
import com.smartling.api.v2.client.ClientConfiguration;
import com.smartling.api.v2.client.ClientFactory;
import com.smartling.api.v2.client.DefaultClientConfiguration;
import com.smartling.api.v2.client.HttpClientConfiguration;
import com.smartling.api.v2.client.auth.Authenticator;
import com.smartling.api.v2.client.auth.AuthorizationRequestFilter;
import com.smartling.api.v2.client.auth.BearerAuthSecretFilter;
import com.smartling.api.v2.client.useragent.LibNameVerionPropertiesReadError;
import com.smartling.api.v2.client.useragent.LibNameVersionHolder;
import com.smartling.api.v2.client.useragent.UserAgentFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import javax.ws.rs.client.ClientRequestFilter;
import lombok.Generated;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApiFactory<T>
implements ApiFactory<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractApiFactory.class);
    private LibNameVersionHolder defaultLibNameVersionHolder;
    private ClientFactory clientFactory;

    protected AbstractApiFactory() {
        this(new ClientFactory());
    }

    protected AbstractApiFactory(ClientFactory clientFactory) {
        Objects.requireNonNull(clientFactory, "clientFactory required");
        this.clientFactory = clientFactory;
        try {
            this.defaultLibNameVersionHolder = new LibNameVersionHolder(this.getApiClass());
        }
        catch (LibNameVerionPropertiesReadError e) {
            log.warn("Could not initialize LibNameVersionHolder from properties: {}", (Object)e.getMessage());
        }
    }

    protected abstract Class<T> getApiClass();

    @Override
    public T buildApi(String userIdentifier, String userSecret) {
        Objects.requireNonNull(userIdentifier, "userIdentifier must be defined");
        Objects.requireNonNull(userSecret, "userSecret must be defined");
        AuthenticationApi authenticationApi = new AuthenticationApiFactory(this.clientFactory).buildApi();
        Authenticator authenticator = new Authenticator(userIdentifier, userSecret, authenticationApi);
        BearerAuthSecretFilter bearerAuthSecretFilter = new BearerAuthSecretFilter(authenticator);
        return this.buildApi(bearerAuthSecretFilter);
    }

    @Override
    public T buildApi(AuthorizationRequestFilter authFilter) {
        return this.buildApi(authFilter, new DefaultClientConfiguration());
    }

    @Override
    public T buildApi(AuthorizationRequestFilter authFilter, ClientConfiguration config) {
        ArrayList<ClientRequestFilter> requestFilters = new ArrayList<ClientRequestFilter>(config.getClientRequestFilters());
        HttpClientConfiguration httpClientConfiguration = config.getHttpClientConfiguration();
        ResteasyProviderFactory providerFactory = config.getResteasyProviderFactory();
        Objects.requireNonNull(authFilter, "authFilter must be defined");
        Objects.requireNonNull(httpClientConfiguration, "httpClientConfiguration must be defined");
        requestFilters.add(authFilter);
        if (config.getLibNameVersionHolder() != null) {
            requestFilters.add(new UserAgentFilter(config.getLibNameVersionHolder()));
        } else if (this.defaultLibNameVersionHolder != null) {
            requestFilters.add(new UserAgentFilter(this.defaultLibNameVersionHolder));
        }
        return this.clientFactory.build(requestFilters, config.getClientResponseFilters(), AbstractApiFactory.getProtocolAndHost(config.getBaseUrl()), this.getApiClass(), httpClientConfiguration, providerFactory, config.getExceptionMapper());
    }

    private static String getProtocolAndHost(URL baseUrl) {
        Objects.requireNonNull(baseUrl, "baseUrl required");
        return baseUrl.toString();
    }
}

