/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.client;

import com.smartling.api.v2.client.exception.RestApiExceptionHandler;
import com.smartling.api.v2.client.exception.server.DetailedErrorMessage;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import lombok.Generated;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExceptionDecoratorInvocationHandler<T>
implements InvocationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExceptionDecoratorInvocationHandler.class);
    private final T delegate;
    private final RestApiExceptionHandler handler;
    private final Map<Method, List<MessageDetailsBuilder>> detailsBuilders = new HashMap<Method, List<MessageDetailsBuilder>>();

    ExceptionDecoratorInvocationHandler(T delegate, RestApiExceptionHandler handler) {
        this.delegate = delegate;
        this.handler = handler;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException ex) {
            if (this.isAnnotationPresent(this.delegate.getClass(), DetailedErrorMessage.class)) {
                if (!this.detailsBuilders.containsKey(method)) {
                    this.detailsBuilders.put(method, this.inspect(method));
                }
                List<MessageDetailsBuilder> detailsBuilders = this.detailsBuilders.get(method);
                StringBuilder errorDetails = new StringBuilder(", method=").append(method.getName());
                for (MessageDetailsBuilder detailsBuilder : detailsBuilders) {
                    detailsBuilder.writeMessage(errorDetails, args);
                }
                throw this.handler.createRestApiException(ex, errorDetails.toString());
            }
            throw this.handler.createRestApiException(ex);
        }
    }

    private List<MessageDetailsBuilder> inspect(Method method) {
        HashSet<String> argNames = new HashSet<String>();
        DetailedErrorMessage annotation = method.getAnnotation(DetailedErrorMessage.class);
        if (annotation != null) {
            argNames.addAll(Arrays.asList(annotation.args()));
        }
        if ((annotation = this.getAnnotationFromInterfaces(this.delegate.getClass(), DetailedErrorMessage.class)) != null) {
            argNames.addAll(Arrays.asList(annotation.args()));
        }
        if (argNames.isEmpty()) {
            return Collections.emptyList();
        }
        return this.lookupArgs(method, argNames);
    }

    private List<MessageDetailsBuilder> lookupArgs(Method method, Set<String> argNames) {
        ArrayList<MessageDetailsBuilder> result = new ArrayList<MessageDetailsBuilder>();
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parametersAnnotations.length && !argNames.isEmpty(); ++i) {
            Annotation[] parameterAnnotations = parametersAnnotations[i];
            String argName = null;
            PathParam path = this.getFromArray(parameterAnnotations, PathParam.class);
            if (path != null) {
                argName = path.value();
            } else {
                QueryParam query = this.getFromArray(parameterAnnotations, QueryParam.class);
                if (query != null) {
                    argName = query.value();
                }
            }
            if (argName == null) {
                Class<?> parameterType = method.getParameterTypes()[i];
                for (Field field : FieldUtils.getAllFields(parameterType)) {
                    if (!argNames.contains(field.getName())) continue;
                    result.add(new MessageDetailsBuilder(i, field.getName(), field));
                    argNames.remove(field.getName());
                }
                continue;
            }
            if (!argNames.contains(argName)) continue;
            result.add(new MessageDetailsBuilder(i, argName, null));
            argNames.remove(argName);
        }
        return result;
    }

    private <A extends Annotation> A getFromArray(Annotation[] parameterAnnotations, Class<A> annotationType) {
        for (Annotation parameterAnnotation : parameterAnnotations) {
            if (parameterAnnotation.annotationType() != annotationType) continue;
            return (A)parameterAnnotation;
        }
        return null;
    }

    private <A extends Annotation> boolean isAnnotationPresent(Class<?> classType, Class<A> annotationClass) {
        return this.getAnnotationFromInterfaces(classType, annotationClass) != null;
    }

    private <A extends Annotation> A getAnnotationFromInterfaces(Class<?> classType, Class<A> annotationClass) {
        for (Class<?> anInterface : classType.getInterfaces()) {
            if (!anInterface.isAnnotationPresent(annotationClass)) continue;
            return anInterface.getAnnotation(annotationClass);
        }
        return classType.getAnnotation(annotationClass);
    }

    static class MessageDetailsBuilder {
        private final int argNumber;
        private final String argName;
        private final Field field;

        void writeMessage(StringBuilder target, Object[] args) {
            try {
                Object arg = args[this.argNumber];
                if (this.field != null) {
                    arg = FieldUtils.readField((Field)this.field, (Object)arg, (boolean)true);
                }
                target.append(", ").append(this.argName).append("=").append(arg);
            }
            catch (Exception ex) {
                log.warn("unable to process arg {} on {} position: ", new Object[]{this.argName, this.argNumber, ex});
            }
        }

        @Generated
        public String toString() {
            return "ExceptionDecoratorInvocationHandler.MessageDetailsBuilder(argNumber=" + this.argNumber + ", argName=" + this.argName + ", field=" + String.valueOf(this.field) + ")";
        }

        @Generated
        public MessageDetailsBuilder(int argNumber, String argName, Field field) {
            this.argNumber = argNumber;
            this.argName = argName;
            this.field = field;
        }
    }
}

