/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.resteasy.ext;

import com.smartling.resteasy.ext.DynamicFormParam;
import com.smartling.resteasy.ext.FileFormParam;
import com.smartling.resteasy.ext.ListFormParam;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.jboss.resteasy.annotations.providers.multipart.PartType;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormAnnotationWriter;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.spi.WriterException;

@Provider
@Produces(value={"multipart/form-data"})
public class ExtendedMultipartFormWriter
extends MultipartFormAnnotationWriter {
    protected void getFields(Class<?> type, MultipartFormDataOutput output, Object obj) throws IOException {
        Field[] declaredFields;
        for (Field field : declaredFields = type.getDeclaredFields()) {
            Object value;
            if (field.isAnnotationPresent(DynamicFormParam.class) && field.isAnnotationPresent(PartType.class)) {
                field.setAccessible(true);
                value = this.safeExtractValue(obj, field);
                if (value instanceof Map) {
                    PartType partType = field.getAnnotation(PartType.class);
                    Map dynamicFields = (Map)value;
                    for (Map.Entry dynamicField : dynamicFields.entrySet()) {
                        if (!(dynamicField.getKey() instanceof String) || !(dynamicField.getValue() instanceof String) && !(dynamicField.getValue() instanceof Integer) && !(dynamicField.getValue() instanceof Boolean)) continue;
                        String fieldKey = (String)dynamicField.getKey();
                        String fieldValue = dynamicField.getValue().toString();
                        output.addFormData(fieldKey, (Object)fieldValue, String.class, String.class, MediaType.valueOf((String)partType.value()), null);
                    }
                }
            }
            if (field.isAnnotationPresent(ListFormParam.class) && field.isAnnotationPresent(PartType.class)) {
                field.setAccessible(true);
                value = this.safeExtractValue(obj, field);
                if (value instanceof List) {
                    Map.Entry dynamicField;
                    ListFormParam param = field.getAnnotation(ListFormParam.class);
                    PartType partType = field.getAnnotation(PartType.class);
                    List array = (List)value;
                    dynamicField = array.iterator();
                    while (dynamicField.hasNext()) {
                        Object item = dynamicField.next();
                        if (!(item instanceof String) && !(item instanceof Integer)) continue;
                        output.addFormData(param.value(), (Object)item.toString(), String.class, String.class, MediaType.valueOf((String)partType.value()), null);
                    }
                }
            }
            if (!field.isAnnotationPresent(FileFormParam.class) || !field.isAnnotationPresent(PartType.class)) continue;
            field.setAccessible(true);
            FileFormParam fileFormParam = field.getAnnotation(FileFormParam.class);
            String name = fileFormParam.value();
            Object value2 = this.safeExtractValue(obj, field);
            String mediaType = field.getAnnotation(PartType.class).value();
            String filename = this.getFilename(obj, declaredFields, field);
            output.addFormData(name, value2, field.getType(), field.getGenericType(), MediaType.valueOf((String)mediaType), filename);
        }
        super.getFields(type, output, obj);
    }

    private String getFilename(Object obj, Field[] declaredFields, Field field) {
        String filenameField = field.getAnnotation(FileFormParam.class).filenameField();
        if (StringUtils.isNotEmpty((CharSequence)filenameField)) {
            for (Field declaredField : declaredFields) {
                if (!declaredField.getName().equals(filenameField)) continue;
                declaredField.setAccessible(true);
                return (String)this.safeExtractValue(obj, declaredField);
            }
        }
        return this.getFilename(field);
    }

    private Object safeExtractValue(Object obj, Field field) {
        Object value;
        try {
            value = field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new WriterException((Throwable)e);
        }
        return value;
    }
}

