/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.client.unmarshal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.smartling.api.v2.response.EmptyData;
import com.smartling.api.v2.response.Response;
import com.smartling.api.v2.response.RestApiResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Priority;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.http.HeaderElement;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=5000)
public class RestApiResponseReaderInterceptor
implements ReaderInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestApiResponseReaderInterceptor.class);
    protected static final EmptyData EMPTY_DATA = new EmptyData();

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        try {
            if (!"application/json".equalsIgnoreCase(this.getResponseContentType(context))) {
                return context.proceed();
            }
            if (RestApiResponse.class.isAssignableFrom(context.getType())) {
                return context.proceed();
            }
            if (InputStream.class.isAssignableFrom(context.getType())) {
                return context.proceed();
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode requestNode = mapper.readTree(context.getInputStream());
            JsonNode node = requestNode.get("response");
            if (!Response.class.isAssignableFrom(context.getType()) && node.has("data")) {
                node = node.get("data");
            }
            if (node.isNull() && EmptyData.class.isAssignableFrom(context.getType())) {
                return EMPTY_DATA;
            }
            context.setInputStream((InputStream)new ByteArrayInputStream(node.toString().getBytes(StandardCharsets.UTF_8)));
            return context.proceed();
        }
        catch (ProcessingException ex) {
            String body = IOUtils.toString((InputStream)context.getInputStream(), (Charset)StandardCharsets.UTF_8);
            Object annotationsView = "";
            for (Annotation annotation : context.getAnnotations()) {
                annotationsView = (String)annotationsView + "\n\t\t" + String.valueOf(annotation);
            }
            String message = "Error during response processing:\n\ttype: " + context.getType().getName() + "\n\tgenericType: " + String.valueOf(context.getGenericType()) + "\n\tannotations: [" + (String)annotationsView + "\n\t]\n\theaders: " + String.valueOf(context.getHeaders()) + "\n\tmedia type: " + String.valueOf(context.getMediaType()) + "\n\tbody: " + body;
            log.error(message);
            throw new ProcessingException(message, (Throwable)ex);
        }
    }

    protected String getResponseContentType(ReaderInterceptorContext context) {
        BasicHeader header;
        HeaderElement[] helems;
        List contentTypeHeaders;
        String contentType = null;
        List list = contentTypeHeaders = context.getHeaders() == null ? null : (List)context.getHeaders().get((Object)"Content-Type");
        if (contentTypeHeaders != null && !contentTypeHeaders.isEmpty() && (helems = (header = new BasicHeader("Content-Type", (String)contentTypeHeaders.get(0))).getElements()).length > 0) {
            contentType = helems[0].getName();
        }
        return contentType;
    }
}

