/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.client.graphql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.smartling.api.v2.client.unmarshal.RestApiResponseReaderInterceptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptorContext;

@Provider
@Priority(value=5000)
public class GraphQlResponseReaderInterceptor
extends RestApiResponseReaderInterceptor {
    @Override
    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        if (!"application/json".equalsIgnoreCase(this.getResponseContentType(context))) {
            return context.proceed();
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode requestNode = mapper.readTree(context.getInputStream());
        JsonNode node = requestNode.get("data");
        if (node.isNull()) {
            return context.proceed();
        }
        context.setInputStream((InputStream)new ByteArrayInputStream(node.toString().getBytes(StandardCharsets.UTF_8)));
        return context.proceed();
    }
}

