/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.client;

import com.smartling.api.v2.authentication.AuthenticationApi;
import com.smartling.api.v2.authentication.AuthenticationApiFactory;
import com.smartling.api.v2.client.ApiFactory;
import com.smartling.api.v2.client.ClientConfiguration;
import com.smartling.api.v2.client.ClientFactory;
import com.smartling.api.v2.client.DefaultClientConfiguration;
import com.smartling.api.v2.client.HttpClientConfiguration;
import com.smartling.api.v2.client.auth.Authenticator;
import com.smartling.api.v2.client.auth.AuthorizationRequestFilter;
import com.smartling.api.v2.client.auth.BearerAuthSecretFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import javax.ws.rs.client.ClientRequestFilter;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public abstract class AbstractApiFactory<T>
implements ApiFactory<T> {
    private ClientFactory clientFactory;

    protected AbstractApiFactory() {
        this(new ClientFactory());
    }

    protected AbstractApiFactory(ClientFactory clientFactory) {
        Objects.requireNonNull(clientFactory, "clientFactory required");
        this.clientFactory = clientFactory;
    }

    protected abstract Class<T> getApiClass();

    @Override
    public T buildApi(String userIdentifier, String userSecret) {
        Objects.requireNonNull(userIdentifier, "userIdentifier must be defined");
        Objects.requireNonNull(userSecret, "userSecret must be defined");
        AuthenticationApi authenticationApi = new AuthenticationApiFactory().buildApi();
        Authenticator authenticator = new Authenticator(userIdentifier, userSecret, authenticationApi);
        BearerAuthSecretFilter bearerAuthSecretFilter = new BearerAuthSecretFilter(authenticator);
        return this.buildApi(bearerAuthSecretFilter);
    }

    @Override
    public T buildApi(AuthorizationRequestFilter authFilter) {
        return this.buildApi(authFilter, new DefaultClientConfiguration());
    }

    @Override
    public T buildApi(AuthorizationRequestFilter authFilter, ClientConfiguration config) {
        ArrayList<ClientRequestFilter> requestFilters = new ArrayList<ClientRequestFilter>(config.getClientRequestFilters());
        HttpClientConfiguration httpClientConfiguration = config.getHttpClientConfiguration();
        ResteasyProviderFactory providerFactory = config.getResteasyProviderFactory();
        Objects.requireNonNull(authFilter, "authFilter must be defined");
        Objects.requireNonNull(httpClientConfiguration, "httpClientConfiguration must be defined");
        requestFilters.add(authFilter);
        return this.clientFactory.build(requestFilters, config.getClientResponseFilters(), AbstractApiFactory.getProtocolAndHost(config.getBaseUrl()), this.getApiClass(), httpClientConfiguration, providerFactory);
    }

    private static String getProtocolAndHost(URL baseUrl) {
        Objects.requireNonNull(baseUrl, "baseUrl required");
        return baseUrl.toString();
    }
}

