/*
 * Decompiled with CFR 0.152.
 */
package com.slimpay.hapiclient.hal;

import com.slimpay.hapiclient.hal.Rel;
import java.net.URI;
import java.util.Locale;

public final class CustomRel
implements Rel {
    private static final long serialVersionUID = 1L;
    private final String name;

    public CustomRel(URI uri) {
        String name = uri.toString().trim();
        if (name.isEmpty()) {
            throw new IllegalArgumentException("The uri is mandatory and can't be empty");
        }
        this.name = name;
    }

    public CustomRel(String name) {
        if (name.trim().isEmpty()) {
            throw new IllegalArgumentException("The name is mandatory and can't be empty.");
        }
        this.name = name.trim();
    }

    public CustomRel(String prefix, String reference) {
        if (prefix.trim().isEmpty()) {
            throw new IllegalArgumentException("The prefix is mandatory and can't be empty.");
        }
        if (reference.trim().isEmpty()) {
            throw new IllegalArgumentException("The reference is mandatory and can't be empty.");
        }
        this.name = String.valueOf(prefix.trim()) + ":" + reference.trim();
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.toLowerCase(Locale.ENGLISH).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.name.toLowerCase(Locale.ENGLISH).equals(((CustomRel)obj).name.toLowerCase(Locale.ENGLISH));
    }

    public String toString() {
        return "CustomRel [name=" + this.name + "]";
    }
}

