/*
 * Decompiled with CFR 0.152.
 */
package com.slimpay.hapiclient.exception;

import com.slimpay.hapiclient.hal.Rel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelNotFoundException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Rel missingRel;
    private final Set<Rel> availableRels;

    public RelNotFoundException(Rel missingRel, Set<Rel> availableRels) {
        super("Rel not found: " + missingRel + ". Relation types available: " + Arrays.toString(availableRels.toArray(new Rel[0])) + ".");
        this.missingRel = missingRel;
        this.availableRels = Collections.unmodifiableSet(availableRels);
    }

    public Rel getMissingRel() {
        return this.missingRel;
    }

    public Set<Rel> getAvailableRels() {
        return this.availableRels;
    }
}

