/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.app_backend.vendor.aws.lambda.util;

import com.slack.api.app_backend.SlackSignature;
import com.slack.api.app_backend.vendor.aws.lambda.request.ApiGatewayRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackSignatureVerifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlackSignatureVerifier.class);
    private final SlackSignature.Verifier verifier;

    public SlackSignatureVerifier() {
        this(new SlackSignature.Generator());
    }

    public SlackSignatureVerifier(SlackSignature.Generator signatureGenerator) {
        this.verifier = new SlackSignature.Verifier(signatureGenerator);
    }

    public boolean isValid(ApiGatewayRequest request) {
        return this.isValid(request, System.currentTimeMillis());
    }

    public boolean isValid(ApiGatewayRequest request, long nowInMillis) {
        if (request != null && request.getHeaders() != null) {
            String requestTimestamp = request.getHeaders().get("X-Slack-Request-Timestamp");
            String requestBody = request.getBody();
            String requestSignature = request.getHeaders().get("X-Slack-Signature");
            return this.verifier.isValid(requestTimestamp, requestBody, requestSignature, nowInMillis);
        }
        return false;
    }
}

