/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.app_backend.events;

import com.slack.api.app_backend.events.EventHandler;
import com.slack.api.app_backend.events.EventTypeExtractor;
import com.slack.api.app_backend.events.EventTypeExtractorImpl;
import com.slack.api.app_backend.events.EventsDispatcher;
import com.slack.api.app_backend.events.payload.EventsApiPayload;
import com.slack.api.util.json.GsonFactory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsDispatcherImpl
implements EventsDispatcher {
    private static final Logger log = LoggerFactory.getLogger(EventsDispatcherImpl.class);
    private final ConcurrentMap<String, List<EventHandler<?>>> eventTypeAndHandlers = new ConcurrentHashMap();
    private AtomicBoolean closed = new AtomicBoolean(false);
    private long maxTerminationDelayMillis = 10000L;
    private final Queue<String> queue = new LinkedList<String>();
    private final Thread eventLoopThread = new Thread(() -> {
        while (true) {
            String json;
            if ((json = this.queue.poll()) != null) {
                log.debug("New message found: {}", (Object)json);
                this.dispatch(json);
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    });
    private final EventTypeExtractor eventTypeExtractor;

    public long getMaxTerminationDelayMillis() {
        return this.maxTerminationDelayMillis;
    }

    public void setMaxTerminationDelayMillis(long maxTerminationDelayMillis) {
        this.maxTerminationDelayMillis = maxTerminationDelayMillis;
    }

    private String toKey(String type, String subtype) {
        StringBuilder sb = new StringBuilder();
        sb.append(type);
        sb.append(":");
        if (subtype == null || subtype.trim().length() == 0) {
            sb.append("null");
        }
        return sb.toString();
    }

    public EventsDispatcherImpl() {
        this(new EventTypeExtractorImpl());
    }

    public EventsDispatcherImpl(EventTypeExtractor eventTypeExtractor) {
        this.eventTypeExtractor = eventTypeExtractor;
    }

    @Override
    public boolean isRunning() {
        return !this.closed.get();
    }

    @Override
    public boolean isEmpty() {
        return this.eventTypeAndHandlers.isEmpty();
    }

    @Override
    public void register(EventHandler<? extends EventsApiPayload<?>> handler) {
        String eventType = handler.getEventType();
        String eventSubtype = handler.getEventSubtype();
        String handlerKey = this.toKey(eventType, eventSubtype);
        List handlers = this.eventTypeAndHandlers.getOrDefault(handlerKey, new ArrayList());
        handlers.add(handler);
        this.eventTypeAndHandlers.put(handlerKey, handlers);
    }

    @Override
    public void deregister(EventHandler<? extends EventsApiPayload<?>> handler) {
        String eventType = handler.getEventType();
        String eventSubtype = handler.getEventSubtype();
        String handlerKey = this.toKey(eventType, eventSubtype);
        List handlers = this.eventTypeAndHandlers.getOrDefault(handlerKey, new ArrayList());
        ArrayList<EventHandler> newHandlers = new ArrayList<EventHandler>();
        for (EventHandler h : handlers) {
            if (h.equals(handler)) continue;
            newHandlers.add(h);
        }
        this.eventTypeAndHandlers.put(handlerKey, newHandlers);
    }

    @Override
    public void dispatch(String json) {
        String eventType = this.eventTypeExtractor.extractEventType(json);
        String eventSubtype = this.eventTypeExtractor.extractEventSubtype(json);
        if (eventType == null) {
            log.debug("Failed to detect event type from the given JSON data: {}", (Object)json);
            return;
        }
        String handlerKey = this.toKey(eventType, eventSubtype);
        List eventHandlers = (List)this.eventTypeAndHandlers.get(handlerKey);
        if (eventHandlers == null || eventHandlers.size() == 0) {
            log.debug("No event handler registered for type: {}, subtype: {}", (Object)eventType, (Object)eventSubtype);
        } else {
            try {
                Class clazz = ((EventHandler)eventHandlers.get(0)).getEventPayloadClass();
                EventsApiPayload event = (EventsApiPayload)GsonFactory.createSnakeCase().fromJson(json, clazz);
                for (EventHandler handler : eventHandlers) {
                    handler.acceptUntypedObject(event);
                }
            }
            catch (Exception ex) {
                log.error("Exception handling event with type: {}, subtype: {}", new Object[]{eventType, eventSubtype, ex});
            }
        }
    }

    @Override
    public void enqueue(String json) {
        if (this.closed.get()) {
            throw new IllegalStateException("EventDispatcher is stopping.");
        }
        this.queue.add(json);
    }

    @Override
    public void start() {
        this.closed.set(false);
        this.eventLoopThread.start();
    }

    @Override
    public void stop() {
        try {
            this.closed.set(true);
            long waitMillis = 0L;
            while (this.queue.size() > 1 & waitMillis < this.getMaxTerminationDelayMillis()) {
                Thread.sleep(50L);
            }
            this.eventLoopThread.interrupt();
        }
        catch (InterruptedException e) {
            this.eventLoopThread.interrupt();
            Thread.currentThread().interrupt();
        }
    }
}

