/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.scim2.impl;

import com.slack.api.rate_limits.RateLimiter;
import com.slack.api.rate_limits.WaitTime;
import com.slack.api.rate_limits.WaitTimeCalculator;
import com.slack.api.rate_limits.metrics.LastMinuteRequests;
import com.slack.api.rate_limits.metrics.MetricsDatastore;
import com.slack.api.rate_limits.metrics.RequestPace;
import com.slack.api.rate_limits.metrics.RequestStats;
import com.slack.api.scim2.SCIM2Config;
import com.slack.api.scim2.SCIM2EndpointName;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSCIM2RateLimiter
implements RateLimiter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncSCIM2RateLimiter.class);
    private final MetricsDatastore metricsDatastore;
    private final String executorName;
    private final SCIMWaitTimeCalculator waitTimeCalculator;

    public MetricsDatastore getMetricsDatastore() {
        return this.metricsDatastore;
    }

    public AsyncSCIM2RateLimiter(SCIM2Config config) {
        this.metricsDatastore = config.getMetricsDatastore();
        this.executorName = config.getExecutorName();
        this.waitTimeCalculator = new SCIMWaitTimeCalculator(config);
    }

    public int getAllowedRequestsPerMinutes(SCIM2EndpointName endpoint) {
        switch (endpoint) {
            case getServiceProviderConfigs: 
            case searchUsers: 
            case searchGroups: {
                return 1000;
            }
            case readUser: 
            case readGroup: {
                return 300;
            }
            case createUser: 
            case patchUser: 
            case updateUser: 
            case deleteUser: 
            case createGroup: 
            case patchGroup: 
            case updateGroup: 
            case deleteGroup: {
                return 180;
            }
        }
        return 180;
    }

    public int getRemainingAllowedRequestsPerMinutesForOrg(SCIM2EndpointName endpoint, RequestStats stats) {
        Map<String, Integer> r = stats.getLastMinuteRequests();
        switch (endpoint) {
            case getServiceProviderConfigs: 
            case searchUsers: 
            case searchGroups: 
            case readUser: 
            case readGroup: {
                return 1000 - (Optional.ofNullable(r.get(SCIM2EndpointName.getServiceProviderConfigs.name())).orElse(0) + Optional.ofNullable(r.get(SCIM2EndpointName.searchUsers.name())).orElse(0) + Optional.ofNullable(r.get(SCIM2EndpointName.searchGroups.name())).orElse(0) + Optional.ofNullable(r.get(SCIM2EndpointName.readUser.name())).orElse(0) + Optional.ofNullable(r.get(SCIM2EndpointName.readGroup.name())).orElse(0));
            }
        }
        return 600 - (Optional.ofNullable(r.get(SCIM2EndpointName.createUser.name())).orElse(0) + Optional.ofNullable(r.get(SCIM2EndpointName.patchUser.name())).orElse(0) + Optional.ofNullable(r.get(SCIM2EndpointName.updateUser.name())).orElse(0) + Optional.ofNullable(r.get(SCIM2EndpointName.deleteUser.name())).orElse(0) + Optional.ofNullable(r.get(SCIM2EndpointName.createGroup.name())).orElse(0) + Optional.ofNullable(r.get(SCIM2EndpointName.patchGroup.name())).orElse(0) + Optional.ofNullable(r.get(SCIM2EndpointName.updateGroup.name())).orElse(0) + Optional.ofNullable(r.get(SCIM2EndpointName.deleteGroup.name())).orElse(0));
    }

    @Override
    public WaitTime acquireWaitTime(String teamId, String methodName) {
        Optional<Long> rateLimitedEpochMillis = this.waitTimeCalculator.getRateLimitedMethodRetryEpochMillis(this.executorName, teamId, methodName);
        if (rateLimitedEpochMillis.isPresent()) {
            long millisToWait = rateLimitedEpochMillis.get() - System.currentTimeMillis();
            return new WaitTime(millisToWait, RequestPace.RateLimited);
        }
        SCIM2EndpointName endpoint = SCIM2EndpointName.valueOf(methodName);
        int orgRemainingRequests = this.getRemainingAllowedRequestsPerMinutesForOrg(endpoint, this.metricsDatastore.getStats(this.executorName, teamId));
        int endpointAllowedRequests = this.getAllowedRequestsPerMinutes(endpoint);
        int allowedRequests = endpointAllowedRequests > orgRemainingRequests ? endpointAllowedRequests : orgRemainingRequests;
        return this.waitTimeCalculator.calculateWaitTime(teamId, methodName, allowedRequests);
    }

    @Override
    public WaitTime acquireWaitTimeForChatPostMessage(String teamId, String channel) {
        throw new IllegalStateException("This rate limiter does not handle the pattern");
    }

    @Override
    public WaitTime acquireWaitTimeForAssistantThreadsSetStatus(String teamId, String channel) {
        throw new IllegalStateException("This rate limiter does not handle the pattern");
    }

    public static class SCIMWaitTimeCalculator
    extends WaitTimeCalculator {
        private final SCIM2Config config;

        public SCIMWaitTimeCalculator(SCIM2Config config) {
            this.config = config;
        }

        @Override
        public Integer getNumberOfNodes() {
            return this.config.getMetricsDatastore().getNumberOfNodes();
        }

        @Override
        public String getExecutorName() {
            return this.config.getExecutorName();
        }

        @Override
        public Optional<Long> getRateLimitedMethodRetryEpochMillis(String executorName, String teamId, String key) {
            return Optional.ofNullable(this.config.getMetricsDatastore().getRateLimitedMethodRetryEpochMillis(executorName, teamId, key));
        }

        @Override
        public LastMinuteRequests getLastMinuteRequests(String executorName, String teamId, String key) {
            return this.config.getMetricsDatastore().getLastMinuteRequests(executorName, teamId, key);
        }
    }
}

