/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.http;

import com.google.gson.Gson;
import com.slack.api.SlackConfig;
import com.slack.api.util.http.UserAgentInterceptor;
import com.slack.api.util.http.listener.HttpResponseListener;
import com.slack.api.util.json.GsonFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackHttpClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlackHttpClient.class);
    private static final MediaType MEDIA_TYPE_APPLICATION_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final OkHttpClient okHttpClient;
    private SlackConfig config = SlackConfig.DEFAULT;

    public static SlackHttpClient buildSlackHttpClient(SlackConfig config) {
        return SlackHttpClient.buildSlackHttpClient(config, Collections.emptyMap());
    }

    public static SlackHttpClient buildSlackHttpClient(SlackConfig config, Map<String, String> userAgentCustomInfo) {
        SlackHttpClient httpClient = new SlackHttpClient(SlackHttpClient.buildOkHttpClient(config, userAgentCustomInfo));
        httpClient.setConfig(config);
        return httpClient;
    }

    public static OkHttpClient buildOkHttpClient(SlackConfig config) {
        return SlackHttpClient.buildOkHttpClient(config, Collections.emptyMap());
    }

    public static OkHttpClient buildOkHttpClient(SlackConfig config, Map<String, String> userAgentCustomInfo) {
        OkHttpClient.Builder okHttpClient = new OkHttpClient.Builder();
        okHttpClient.addInterceptor((Interceptor)new UserAgentInterceptor(userAgentCustomInfo));
        if (config.getHttpClientReadTimeoutMillis() != null) {
            okHttpClient.readTimeout((long)config.getHttpClientReadTimeoutMillis().intValue(), TimeUnit.MILLISECONDS);
        }
        if (config.getHttpClientWriteTimeoutMillis() != null) {
            okHttpClient.writeTimeout((long)config.getHttpClientWriteTimeoutMillis().intValue(), TimeUnit.MILLISECONDS);
        }
        if (config.getHttpClientCallTimeoutMillis() != null) {
            okHttpClient.callTimeout((long)config.getHttpClientCallTimeoutMillis().intValue(), TimeUnit.MILLISECONDS);
        }
        if (config.getProxyUrl() != null && !config.getProxyUrl().trim().isEmpty()) {
            try {
                URL url = new URL(config.getProxyUrl());
                InetSocketAddress address = new InetSocketAddress(url.getHost(), url.getPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                okHttpClient.proxy(proxy);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Failed to parse the proxy URL: " + config.getProxyUrl());
            }
        }
        return okHttpClient.build();
    }

    public SlackHttpClient() {
        this(Collections.emptyMap());
    }

    public SlackHttpClient(Map<String, String> userAgentCustomInfo) {
        this(SlackConfig.DEFAULT, userAgentCustomInfo);
    }

    public SlackHttpClient(SlackConfig config, Map<String, String> userAgentCustomInfo) {
        this.okHttpClient = SlackHttpClient.buildOkHttpClient(config, userAgentCustomInfo);
    }

    public SlackHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    @Override
    public void close() throws Exception {
        this.okHttpClient.dispatcher().executorService().shutdown();
        this.okHttpClient.connectionPool().evictAll();
        if (this.okHttpClient.cache() != null) {
            this.okHttpClient.cache().close();
        }
    }

    public SlackConfig getConfig() {
        return this.config;
    }

    public void setConfig(SlackConfig config) {
        this.config = config;
    }

    public Response get(String url, Map<String, String> query, String token) throws IOException {
        Request request;
        if (query != null) {
            HttpUrl.Builder u = HttpUrl.parse((String)url).newBuilder();
            for (Map.Entry<String, String> each : query.entrySet()) {
                u = u.addQueryParameter(each.getKey(), each.getValue());
            }
            url = u.build().toString();
        }
        if (token != null) {
            String bearerHeaderValue = "Bearer " + token;
            Request.Builder rb = new Request.Builder().url(url).get();
            try {
                rb = rb.header("Authorization", bearerHeaderValue);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid value detected for Authorization header");
            }
            request = rb.build();
            return this.okHttpClient.newCall(request).execute();
        }
        request = new Request.Builder().url(url).get().build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response postMultipart(String url, String token, MultipartBody multipartBody) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        Request.Builder rb = new Request.Builder().url(url).post((RequestBody)multipartBody);
        try {
            rb = rb.header("Authorization", bearerHeaderValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid value detected for Authorization header");
        }
        Request request = rb.build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response postForm(String url, FormBody formBody) throws IOException {
        Request request = new Request.Builder().url(url).post((RequestBody)formBody).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response postFormWithBearerHeader(String url, String token, FormBody formBody) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        return this.postFormWithAuthorizationHeader(url, bearerHeaderValue, formBody);
    }

    public Response postFormWithAuthorizationHeader(String url, String authorizationHeader, FormBody formBody) throws IOException {
        Request.Builder rb = new Request.Builder().url(url).post((RequestBody)formBody);
        try {
            rb = rb.header("Authorization", authorizationHeader);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid value detected for Authorization header");
        }
        Request request = rb.build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response postJsonBody(String url, Object obj) throws IOException {
        RequestBody body = RequestBody.create((String)this.toSnakeCaseJsonString(obj), (MediaType)MEDIA_TYPE_APPLICATION_JSON);
        Request request = new Request.Builder().url(url).post(body).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response postCamelCaseJsonBodyWithBearerHeader(String url, String token, Object obj) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        RequestBody body = RequestBody.create((String)this.toCamelCaseJsonString(obj), (MediaType)MEDIA_TYPE_APPLICATION_JSON);
        Request.Builder rb = new Request.Builder().url(url).post(body);
        try {
            rb = rb.header("Authorization", bearerHeaderValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid value detected for Authorization header");
        }
        Request request = rb.build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response patchCamelCaseJsonBodyWithBearerHeader(String url, String token, Object obj) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        RequestBody body = RequestBody.create((String)this.toCamelCaseJsonString(obj), (MediaType)MEDIA_TYPE_APPLICATION_JSON);
        Request.Builder rb = new Request.Builder().url(url).patch(body);
        try {
            rb = rb.header("Authorization", bearerHeaderValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid value detected for Authorization header");
        }
        Request request = rb.build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response putCamelCaseJsonBodyWithBearerHeader(String url, String token, Object obj) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        RequestBody body = RequestBody.create((String)this.toCamelCaseJsonString(obj), (MediaType)MEDIA_TYPE_APPLICATION_JSON);
        Request.Builder rb = new Request.Builder().url(url).put(body);
        try {
            rb = rb.header("Authorization", bearerHeaderValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid value detected for Authorization header");
        }
        Request request = rb.build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response delete(Request.Builder requestBuilder) throws IOException {
        return this.okHttpClient.newCall(requestBuilder.method("DELETE", null).build()).execute();
    }

    private String toSnakeCaseJsonString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        Gson gson = GsonFactory.createSnakeCase(this.config);
        return gson.toJson(obj);
    }

    private String toCamelCaseJsonString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        Gson gson = GsonFactory.createCamelCase(this.config);
        return gson.toJson(obj);
    }

    public void runHttpResponseListeners(Response response, String body) {
        HttpResponseListener.State state = new HttpResponseListener.State(this.config, response, body);
        for (HttpResponseListener responseListener : this.config.getHttpClientResponseHandlers()) {
            responseListener.accept(state);
        }
    }
}

