/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.scim.impl;

import com.slack.api.scim.SCIMConfig;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;

public class ThreadPools {
    private static final ConcurrentMap<String, ConcurrentMap<String, ExecutorService>> ALL_DEFAULT = new ConcurrentHashMap<String, ConcurrentMap<String, ExecutorService>>();
    private static final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, ExecutorService>>> ENTERPRISE_CUSTOM = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<String, ExecutorService>>>();

    private ThreadPools() {
    }

    public static ExecutorService getDefault(SCIMConfig config) {
        return ThreadPools.getOrCreate(config, null);
    }

    public static ExecutorService getOrCreate(SCIMConfig config, String enterpriseId) {
        Integer orgCustomPoolSize;
        String providerInstanceId = config.getExecutorServiceProvider().toString();
        Integer n = orgCustomPoolSize = enterpriseId != null ? config.getCustomThreadPoolSizes().get(enterpriseId) : null;
        if (orgCustomPoolSize != null) {
            return ENTERPRISE_CUSTOM.computeIfAbsent(providerInstanceId, _id -> new ConcurrentHashMap()).computeIfAbsent(config.getExecutorName(), _name -> new ConcurrentHashMap()).computeIfAbsent(enterpriseId, _id -> ThreadPools.buildNewExecutorService(config, enterpriseId, orgCustomPoolSize));
        }
        return ALL_DEFAULT.computeIfAbsent(providerInstanceId, _id -> new ConcurrentHashMap()).computeIfAbsent(config.getExecutorName(), _name -> ThreadPools.buildNewExecutorService(config));
    }

    private static ExecutorService buildNewExecutorService(SCIMConfig config) {
        String threadGroupName = "slack-scim-" + config.getExecutorName();
        int poolSize = config.getDefaultThreadPoolSize();
        return config.getExecutorServiceProvider().createThreadPoolExecutor(threadGroupName, poolSize);
    }

    private static ExecutorService buildNewExecutorService(SCIMConfig config, String enterpriseId, Integer customPoolSize) {
        String threadGroupName = "slack-scim-" + config.getExecutorName() + "-" + enterpriseId;
        return config.getExecutorServiceProvider().createThreadPoolExecutor(threadGroupName, customPoolSize.intValue());
    }
}

