/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.methods.impl;

import com.slack.api.methods.MethodsConfig;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;

public class ThreadPools {
    private static final ConcurrentMap<String, ConcurrentMap<String, ExecutorService>> ALL_DEFAULT = new ConcurrentHashMap<String, ConcurrentMap<String, ExecutorService>>();
    private static final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, ExecutorService>>> TEAM_CUSTOM = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<String, ExecutorService>>>();

    private ThreadPools() {
    }

    public static ExecutorService getDefault(MethodsConfig config) {
        return ThreadPools.getOrCreate(config, null);
    }

    public static ExecutorService getOrCreate(MethodsConfig config, String teamId) {
        Integer teamCustomPoolSize;
        String providerInstanceId = config.getExecutorServiceProvider().toString();
        Integer n = teamCustomPoolSize = teamId != null ? config.getCustomThreadPoolSizes().get(teamId) : null;
        if (teamCustomPoolSize != null) {
            return TEAM_CUSTOM.computeIfAbsent(providerInstanceId, _id -> new ConcurrentHashMap()).computeIfAbsent(config.getExecutorName(), _name -> new ConcurrentHashMap()).computeIfAbsent(teamId, _id -> ThreadPools.buildNewExecutorService(config, teamId, teamCustomPoolSize));
        }
        return ALL_DEFAULT.computeIfAbsent(providerInstanceId, _id -> new ConcurrentHashMap()).computeIfAbsent(config.getExecutorName(), _name -> ThreadPools.buildNewExecutorService(config));
    }

    private static ExecutorService buildNewExecutorService(MethodsConfig config) {
        String threadGroupName = "slack-methods-" + config.getExecutorName();
        int poolSize = config.getDefaultThreadPoolSize();
        return config.getExecutorServiceProvider().createThreadPoolExecutor(threadGroupName, poolSize);
    }

    private static ExecutorService buildNewExecutorService(MethodsConfig config, String teamId, Integer customPoolSize) {
        String threadGroupName = "slack-methods-" + config.getExecutorName() + "-" + teamId;
        return config.getExecutorServiceProvider().createThreadPoolExecutor(threadGroupName, customPoolSize.intValue());
    }
}

