/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api;

import com.slack.api.SlackConfig;
import com.slack.api.audit.AuditClient;
import com.slack.api.audit.impl.AuditClientImpl;
import com.slack.api.methods.AsyncMethodsClient;
import com.slack.api.methods.MethodsClient;
import com.slack.api.methods.MethodsStats;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.impl.AsyncMethodsClientImpl;
import com.slack.api.methods.impl.MethodsClientImpl;
import com.slack.api.methods.request.rtm.RTMConnectRequest;
import com.slack.api.methods.request.rtm.RTMStartRequest;
import com.slack.api.methods.request.users.UsersInfoRequest;
import com.slack.api.methods.response.rtm.RTMConnectResponse;
import com.slack.api.methods.response.rtm.RTMStartResponse;
import com.slack.api.methods.response.users.UsersInfoResponse;
import com.slack.api.model.User;
import com.slack.api.rtm.RTMClient;
import com.slack.api.scim.SCIMClient;
import com.slack.api.scim.impl.SCIMClientImpl;
import com.slack.api.status.v1.LegacyStatusClient;
import com.slack.api.status.v1.impl.LegacyStatusClientImpl;
import com.slack.api.status.v2.StatusClient;
import com.slack.api.status.v2.impl.StatusClientImpl;
import com.slack.api.util.http.SlackHttpClient;
import com.slack.api.webhook.Payload;
import com.slack.api.webhook.WebhookResponse;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slack
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Slack.class);
    private static final Slack SINGLETON = new Slack(SlackConfig.DEFAULT, new SlackHttpClient());
    private final SlackHttpClient httpClient;
    private final SlackConfig config;

    public Slack() {
        this(SlackConfig.DEFAULT, Slack.buildHttpClient(SlackConfig.DEFAULT));
    }

    private Slack(SlackConfig config) {
        this(config, Slack.buildHttpClient(config));
    }

    private Slack(SlackConfig config, SlackHttpClient httpClient) {
        this.config = config;
        this.httpClient = httpClient;
        this.httpClient.setConfig(this.config);
    }

    public static Slack getInstance() {
        return SINGLETON;
    }

    public static Slack getInstance(SlackConfig config) {
        return new Slack(config);
    }

    public static Slack getInstance(SlackConfig config, SlackHttpClient httpClient) {
        return new Slack(config, httpClient);
    }

    public static Slack getInstance(SlackHttpClient httpClient) {
        return new Slack(SlackConfig.DEFAULT, httpClient);
    }

    public SlackHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public void close() throws Exception {
        this.getHttpClient().close();
    }

    public WebhookResponse send(String url, Payload payload) throws IOException {
        SlackHttpClient httpClient = this.getHttpClient();
        Response httpResponse = httpClient.postJsonBody(url, payload);
        String body = httpResponse.body().string();
        httpClient.runHttpResponseListeners(httpResponse, body);
        return WebhookResponse.builder().code(Integer.valueOf(httpResponse.code())).message(httpResponse.message()).body(body).build();
    }

    public WebhookResponse send(String url, String payload) throws IOException {
        SlackHttpClient httpClient = this.getHttpClient();
        Response httpResponse = httpClient.postJsonBody(url, payload);
        String body = httpResponse.body().string();
        httpClient.runHttpResponseListeners(httpResponse, body);
        return WebhookResponse.builder().code(Integer.valueOf(httpResponse.code())).message(httpResponse.message()).body(body).build();
    }

    public RTMClient rtm(String apiToken) throws IOException {
        return this.rtmConnect(apiToken);
    }

    public RTMClient rtmConnect(String apiToken) throws IOException {
        return this.rtmConnect(apiToken, true);
    }

    public RTMClient rtmConnect(String apiToken, boolean fullUserInfoRequired) throws IOException {
        try {
            RTMConnectResponse response = this.methods().rtmConnect(RTMConnectRequest.builder().token(apiToken).build());
            if (response.isOk()) {
                User connectedBotUser = response.getSelf();
                if (fullUserInfoRequired) {
                    String userId = response.getSelf().getId();
                    UsersInfoResponse resp = this.methods().usersInfo(UsersInfoRequest.builder().token(apiToken).user(userId).build());
                    if (resp.isOk()) {
                        connectedBotUser = resp.getUser();
                    } else {
                        String errorMessage = "Failed to get fill user info (user id: " + response.getSelf().getId() + ", error: " + resp.getError() + ")";
                        throw new IllegalStateException(errorMessage);
                    }
                }
                return new RTMClient(this, apiToken, response.getUrl(), connectedBotUser);
            }
            throw new IllegalStateException("Failed to the RTM endpoint URL (error: " + response.getError() + ")");
        }
        catch (SlackApiException e) {
            throw new IllegalStateException("Failed to connect to the RTM API endpoint. (status: " + e.getResponse().code() + ", error: " + e.getError().getError() + ")", e);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to connect to the RTM API endpoint. (message: " + e.getMessage() + ")", e);
        }
    }

    public RTMClient rtmStart(String apiToken) throws IOException {
        return this.rtmStart(apiToken, true);
    }

    public RTMClient rtmStart(String apiToken, boolean fullUserInfoRequired) throws IOException {
        try {
            RTMStartResponse response = this.methods().rtmStart(RTMStartRequest.builder().token(apiToken).build());
            if (response.isOk()) {
                User connectedBotUser = response.getSelf();
                if (fullUserInfoRequired) {
                    String userId = response.getSelf().getId();
                    UsersInfoResponse resp = this.methods().usersInfo(UsersInfoRequest.builder().token(apiToken).user(userId).build());
                    if (resp.isOk()) {
                        connectedBotUser = resp.getUser();
                    } else {
                        String errorMessage = "Failed to get fill user info (user id: " + response.getSelf().getId() + ", error: " + resp.getError() + ")";
                        throw new IllegalStateException(errorMessage);
                    }
                }
                return new RTMClient(this, apiToken, response.getUrl(), connectedBotUser);
            }
            throw new IllegalStateException("Failed to the RTM endpoint URL (error: " + response.getError() + ")");
        }
        catch (SlackApiException e) {
            throw new IllegalStateException("Failed to connect to the RTM API endpoint. (status: " + e.getResponse().code() + ", error: " + e.getError().getError() + ")", e);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to connect to the RTM API endpoint. (message: " + e.getMessage() + ")", e);
        }
    }

    public LegacyStatusClient statusLegacy() {
        LegacyStatusClientImpl client = new LegacyStatusClientImpl(this.httpClient);
        client.setEndpointUrlPrefix(this.config.getLegacyStatusEndpointUrlPrefix());
        return client;
    }

    public StatusClient status() {
        StatusClientImpl client = new StatusClientImpl(this.httpClient);
        client.setEndpointUrlPrefix(this.config.getStatusEndpointUrlPrefix());
        return client;
    }

    public SCIMClient scim() {
        return this.scim(null);
    }

    public SCIMClient scim(String token) {
        SCIMClientImpl client = new SCIMClientImpl(this.httpClient, token);
        client.setEndpointUrlPrefix(this.config.getScimEndpointUrlPrefix());
        return client;
    }

    public AuditClient audit() {
        return this.audit(null);
    }

    public AuditClient audit(String token) {
        AuditClientImpl client = new AuditClientImpl(this.httpClient, token);
        client.setEndpointUrlPrefix(this.config.getAuditEndpointUrlPrefix());
        return client;
    }

    public MethodsClient methods() {
        return this.methods(null);
    }

    public MethodsClient methods(String token) {
        MethodsClientImpl client = new MethodsClientImpl(this.httpClient, token);
        client.setEndpointUrlPrefix(this.config.getMethodsEndpointUrlPrefix());
        return client;
    }

    public AsyncMethodsClient methodsAsync() {
        return this.methodsAsync(null);
    }

    public AsyncMethodsClient methodsAsync(String token) {
        return new AsyncMethodsClientImpl(token, this.methods(token), this.config);
    }

    public MethodsStats methodsStats(String teamId) {
        return this.methodsStats("DEFAULT_SINGLETON_EXECUTOR", teamId);
    }

    public MethodsStats methodsStats(String executorName, String teamId) {
        return this.config.getMethodsConfig().getMetricsDatastore().getStats(executorName, teamId);
    }

    private static SlackHttpClient buildHttpClient(SlackConfig config) {
        OkHttpClient okHttpClient;
        if (config.getProxyUrl() != null && !config.getProxyUrl().trim().isEmpty()) {
            try {
                URL url = new URL(config.getProxyUrl());
                InetSocketAddress address = new InetSocketAddress(url.getHost(), url.getPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                okHttpClient = new OkHttpClient.Builder().proxy(proxy).build();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Failed to parse the proxy URL: " + config.getProxyUrl());
            }
        } else {
            okHttpClient = new OkHttpClient.Builder().build();
        }
        SlackHttpClient httpClient = new SlackHttpClient(okHttpClient);
        httpClient.setConfig(config);
        return httpClient;
    }
}

